/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import meka.classifiers.multilabel.Evaluation;
import meka.classifiers.multilabel.IncrementalEvaluation;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;

public abstract class MultilabelClassifier
extends SingleClassifierEnhancer {
    private static final long serialVersionUID = 1713843369766127169L;
    protected Instances m_InstancesTemplate;

    public String globalInfo() {
        return "A multi-label classifier";
    }

    public MultilabelClassifier() {
        this.m_Classifier = new J48();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public String toString() {
        return "";
    }

    public Instances getTemplate() {
        return this.m_InstancesTemplate;
    }

    public void testCapabilities(Instances D) throws Exception {
        Capabilities cap = this.getCapabilities();
        cap.enableAllClasses();
        int L = D.classIndex();
        for (int j = 0; j < L; ++j) {
            Attribute c = D.attribute(j);
            cap.testWithFail(c, true);
        }
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disable(Capabilities.Capability.NUMERIC_CLASS);
        result.disable(Capabilities.Capability.DATE_CLASS);
        result.disable(Capabilities.Capability.STRING_CLASS);
        result.disable(Capabilities.Capability.RELATIONAL_CLASS);
        return result;
    }

    public abstract void buildClassifier(Instances var1) throws Exception;

    public abstract double[] distributionForInstance(Instance var1) throws Exception;

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static MultilabelClassifier[] makeCopies(MultilabelClassifier model, int num) throws Exception {
        if (model == null) {
            throw new Exception("No model classifier set");
        }
        MultilabelClassifier[] classifiers = new MultilabelClassifier[num];
        SerializedObject so = new SerializedObject((Object)model);
        for (int i = 0; i < classifiers.length; ++i) {
            classifiers[i] = (MultilabelClassifier)((Object)so.getObject());
        }
        return classifiers;
    }

    public static void evaluation(MultilabelClassifier h, String[] args) {
        MultilabelClassifier.runClassifier(h, args);
    }

    public static void runClassifier(MultilabelClassifier h, String[] args) {
        if (h instanceof UpdateableClassifier) {
            try {
                IncrementalEvaluation.runExperiment(h, args);
            }
            catch (Exception e) {
                System.err.println("\n" + e);
                IncrementalEvaluation.printOptions(h.listOptions());
            }
        } else {
            try {
                Evaluation.runExperiment(h, args);
            }
            catch (Exception e) {
                System.err.println("\n" + e);
                Evaluation.printOptions(h.listOptions());
            }
        }
    }
}

