/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.List;
import meka.classifiers.multilabel.MultilabelClassifier;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class RT
extends MultilabelClassifier {
    private static final long serialVersionUID = 7348139531854838421L;

    @Override
    public String globalInfo() {
        return "Duplicates each multi-labelled example, and assigns one of the labels (only) to each copy; then trains a regular multi-class base classifier.\nAt test time, a threshold separates relevant from irrelevant labels using the posterior for each class value (i.e., label).";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        Instances D_ = new Instances(D, 0, 0);
        for (int j = 0; j < L; ++j) {
            D_.deleteAttributeAt(0);
        }
        FastVector classes = new FastVector(L);
        for (int j = 0; j < L; ++j) {
            classes.addElement((Object)("C" + j));
        }
        D_.insertAttributeAt(new Attribute("ClassY", (List)classes), 0);
        D_.setClassIndex(0);
        for (int i = 0; i < D.numInstances(); ++i) {
            for (int j = 0; j < L; ++j) {
                if ((int)D.instance(i).value(j) <= 0) continue;
                Instance x_ = (Instance)D.instance(i).copy();
                x_.setDataset(null);
                for (int k = 1; k < L; ++k) {
                    x_.deleteAttributeAt(1);
                }
                x_.setDataset(D_);
                x_.setClassValue((double)j);
                D_.add(x_);
            }
        }
        this.m_InstancesTemplate = new Instances(D_, 0);
        if (this.getDebug()) {
            System.out.println("Building classifier " + this.m_Classifier.getClass().getName() + " on " + D_.numInstances() + " instances (originally " + D.numInstances() + ")");
        }
        this.m_Classifier.buildClassifier(D_);
    }

    public Instance convertInstance(Instance x) {
        int L = x.classIndex();
        Instance x_ = (Instance)x.copy();
        x_.setDataset(null);
        for (int i = 0; i < L; ++i) {
            x_.deleteAttributeAt(0);
        }
        x_.insertAttributeAt(0);
        x_.setDataset(this.m_InstancesTemplate);
        return x_;
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        return this.m_Classifier.distributionForInstance(this.convertInstance(x));
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new RT(), args);
    }
}

