/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.cc;

import java.io.Serializable;
import meka.core.A;
import meka.core.StatUtils;
import weka.core.Instances;

public class Trellis
implements Serializable {
    public int[][] trellis;
    public int[] indices;
    public int WIDTH;
    public int TYPE;
    public int L = -1;

    public Trellis(int[] indicies, int WIDTH, int conectivity) {
        this.indices = indicies;
        this.L = this.indices.length;
        this.WIDTH = WIDTH;
        this.TYPE = conectivity;
        this.make();
    }

    public Trellis(int[] indicies, int[][] trellis, int WIDTH, int conectivity) {
        this.indices = indicies;
        this.trellis = trellis;
        this.WIDTH = WIDTH;
        this.TYPE = conectivity;
        this.L = this.indices.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        for (int jv : this.indices) {
            String num = String.format("%3d", jv);
            sb.append(num);
            if (++counter % this.WIDTH != 0) continue;
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public void swap(int j, int k) {
        this.indices = A.swap(this.indices, j, k);
        int jv = this.indices[j];
        int kv = this.indices[k];
        this.trellis[jv] = this.getParents(j, this.indices, this.WIDTH, this.TYPE);
        this.trellis[kv] = this.getParents(k, this.indices, this.WIDTH, this.TYPE);
    }

    public void putTogether(int j, int k) {
        int jv = this.indices[j];
        int kv = this.indices[k];
        if (jv + 1 % this.WIDTH != 0) {
            this.swap(j + 1, k);
        } else if (kv + 1 % this.WIDTH != 0) {
            this.swap(j, k + 1);
        } else {
            System.out.println("DO SOMETHING ELSE");
        }
    }

    private int[] ne(int j) {
        return new int[0];
    }

    public double weight(Instances D) {
        double sum = 0.0;
        for (int jv : this.indices) {
            for (int pa : this.trellis[jv]) {
                sum += StatUtils.I(D, pa, jv);
            }
        }
        return sum;
    }

    public double weightNeighbourhood(int j) {
        double w = 0.0;
        for (int n : this.ne(j)) {
        }
        return w;
    }

    public double weight(int[] indices, int j, int j_, double[][] I) {
        int[] pa_j = this.getParents(j, indices, this.WIDTH, this.TYPE);
        double weight = 0.0;
        for (int pj : pa_j) {
            weight += I[pj][j_];
        }
        return weight;
    }

    private final int COL_INDEX(int j) {
        return j % this.WIDTH;
    }

    private final int ROW_INDEX(int j) {
        return j / this.WIDTH;
    }

    public int[] getNeighbours(int j) {
        int[] ne_j = new int[]{};
        if (this.TYPE > 0) {
            if (j >= 1 && j % this.WIDTH > 0) {
                ne_j = A.append(ne_j, this.indices[j - 1]);
            }
            if (j >= this.WIDTH) {
                ne_j = A.append(ne_j, this.indices[j - this.WIDTH]);
            }
            if (j < this.indices.length - 1 && (j + 1) % this.WIDTH > 0) {
                ne_j = A.append(ne_j, this.indices[j + 1]);
            }
            if (j < this.indices.length - this.WIDTH) {
                ne_j = A.append(ne_j, this.indices[j + this.WIDTH]);
            }
        }
        if (this.TYPE > 1) {
            if (j >= 1 && j >= this.WIDTH & j % this.WIDTH > 0) {
                ne_j = A.append(ne_j, this.indices[j - 1 - this.WIDTH]);
            }
            if (this.COL_INDEX(j) < this.WIDTH - 1 && j >= this.WIDTH) {
                ne_j = A.append(ne_j, this.indices[j - this.WIDTH + 1]);
            }
            if (j < this.L - this.WIDTH && this.COL_INDEX(j) > 0) {
                ne_j = A.append(ne_j, this.indices[j + 1]);
            }
            if (this.COL_INDEX(j) < this.WIDTH - 1 && this.L - j > this.WIDTH) {
                ne_j = A.append(ne_j, this.indices[j + this.WIDTH + 1]);
            }
        }
        return ne_j;
    }

    private int[] getParents(int j, int[] indices, int WIDTH, int CONNECTIVITY) {
        int[] pa_j = new int[]{};
        if (CONNECTIVITY > 0) {
            if (j >= 1 && j % WIDTH > 0) {
                pa_j = A.append(pa_j, indices[j - 1]);
            }
            if (j >= WIDTH) {
                pa_j = A.append(pa_j, indices[j - WIDTH]);
            }
        }
        if (CONNECTIVITY > 1 && j >= 1 && j >= WIDTH & j % WIDTH > 0) {
            pa_j = A.append(pa_j, indices[j - WIDTH - 1]);
        }
        if (CONNECTIVITY > 2) {
            if (j % WIDTH >= 2) {
                pa_j = A.append(pa_j, indices[j - 2]);
            }
            if (j >= WIDTH * 2) {
                pa_j = A.append(pa_j, indices[j - WIDTH * 2]);
            }
        }
        return pa_j;
    }

    public void make() {
        this.trellis = new int[this.L][];
        for (int j = 0; j < this.L; ++j) {
            int jv = this.indices[j];
            this.trellis[jv] = this.getParents(j, this.indices, this.WIDTH, this.TYPE);
        }
    }
}

