/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.meta.EM;
import meka.core.MLUtils;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class CM
extends EM {
    @Override
    public String globalInfo() {
        return "Train a classifier using labelled and unlabelled data (semi-supervised) using Classification Expectation algorithm (a hard version of EM). Unlike EM, can use any classifier here, not necessarily one which gives good probabilistic output.";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        if (this.getDebug()) {
            System.out.println("Initial build ...");
        }
        this.m_Classifier.buildClassifier(D);
        Instances DA = MLUtils.combineInstances(D, this.D_);
        if (this.getDebug()) {
            System.out.print("Performing " + this.m_I + " 'CM' Iterations: [");
        }
        for (int i = 0; i < this.m_I; ++i) {
            if (this.getDebug()) {
                System.out.print(".");
            }
            this.updateWeights((MultilabelClassifier)this.m_Classifier, DA);
            this.m_Classifier.buildClassifier(DA);
        }
        System.out.println("]");
    }

    @Override
    protected void updateWeights(MultilabelClassifier h, Instances D) throws Exception {
        for (Instance x : D) {
            double[] y = h.distributionForInstance(x);
            for (int j = 0; j < y.length; ++j) {
                x.setValue(j, y[j] < 0.5 ? 0.0 : 1.0);
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new CM(), args);
    }
}

