/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import Jama.Matrix;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.NN.AbstractDeepNeuralNet;
import meka.core.M;
import meka.core.MLUtils;
import rbms.DBM;
import rbms.RBM;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Randomizable;

public class DeepML
extends AbstractDeepNeuralNet
implements Randomizable {
    protected RBM dbm = null;
    protected long rbm_time = 0L;
    protected int m_Seed = 0;

    protected RBM createDBM(int d) throws Exception {
        return this.m_N == 1 ? new RBM(this.getOptions()) : new DBM(this.getOptions());
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        int d = D.numAttributes() - L;
        double[][] X_ = MLUtils.getXfromD(D);
        this.dbm = this.createDBM(d);
        this.dbm.setSeed(this.m_Seed);
        this.dbm.setE(this.m_E);
        long before = System.currentTimeMillis();
        this.dbm.train(X_, L);
        this.rbm_time = System.currentTimeMillis() - before;
        double[][] Z = this.dbm.prob_Z(X_);
        if (this.getDebug()) {
            Matrix[] tW = this.dbm.getWs();
            System.out.println("X = \n" + M.toString(X_));
            System.out.println("W = \n" + M.toString(tW[0].getArray()));
            System.out.println("Y = \n" + M.toString(MLUtils.getYfromD(D), 0));
            System.out.println("Z = \n" + M.toString(M.threshold(Z, 0.5), 0));
        }
        this.m_InstancesTemplate = new Instances(MLUtils.replaceZasAttributes(D, Z, L));
        this.m_Classifier.buildClassifier(this.m_InstancesTemplate);
    }

    @Override
    public double[] distributionForInstance(Instance xy) throws Exception {
        int L = xy.classIndex();
        double[] z = this.dbm.prob_z(MLUtils.getxfromInstance(xy));
        Instance zy = (Instance)this.m_InstancesTemplate.firstInstance().copy();
        MLUtils.setValues(zy, z, L);
        zy.setDataset(this.m_InstancesTemplate);
        return this.m_Classifier.distributionForInstance(zy);
    }

    @Override
    public String toString() {
        return super.toString() + ", RBM-Build_Time=" + this.rbm_time;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int s) {
        this.m_Seed = s;
    }

    public static void main(String[] args) throws Exception {
        MultilabelClassifier.evaluation(new DeepML(), args);
    }
}

