/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import java.util.Enumeration;
import java.util.Vector;
import meka.classifiers.multilabel.CC;
import meka.classifiers.multilabel.MultilabelClassifier;
import weka.core.Instance;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.Utils;

public abstract class MultilabelMetaClassifier
extends MultilabelClassifier
implements Randomizable {
    private static final long serialVersionUID = -6604797895790690612L;
    protected MultilabelClassifier[] m_Classifiers = null;
    protected int m_Seed = 1;
    protected int m_NumIterations = 10;
    protected int m_BagSizePercent = 67;

    @Override
    public String globalInfo() {
        return "For ensembles of multi-label methods.";
    }

    public MultilabelMetaClassifier() {
        this.m_Classifier = new CC();
    }

    @Override
    protected String defaultClassifierString() {
        return "meka.classifiers.multilabel.CC";
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        double[] p = new double[x.classIndex()];
        for (int i = 0; i < this.m_NumIterations; ++i) {
            double[] d = this.m_Classifiers[i].distributionForInstance(x);
            for (int j = 0; j < d.length; ++j) {
                int n = j;
                p[n] = p[n] + d[j];
            }
        }
        for (int j = 0; j < p.length; ++j) {
            p[j] = p[j] / (double)this.m_NumIterations;
        }
        return p;
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public void setNumIterations(int n) {
        this.m_NumIterations = n;
    }

    public int getBagSizePercent() {
        return this.m_BagSizePercent;
    }

    public void setBagSizePercent(int p) {
        this.m_BagSizePercent = p;
    }

    public void setSeed(int s) {
        this.m_Seed = s;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tSets the number of models (default " + this.m_NumIterations + ")", "I", 1, "-I <num>"));
        newVector.addElement(new Option("\tSize of each bag, as a percentage of total training size (default " + this.m_BagSizePercent + ")", "P", 1, "-P <size percentage>"));
        newVector.addElement(new Option("\tRandom number seed for sampling (default " + this.m_Seed + ")", "S", 1, "-S <seed>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'S', (String[])options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        }
        if ((tmpStr = Utils.getOption((char)'I', (String[])options)).length() != 0) {
            this.setNumIterations(Integer.parseInt(tmpStr));
        }
        if ((tmpStr = Utils.getOption((char)'P', (String[])options)).length() != 0) {
            this.setBagSizePercent(Integer.parseInt(tmpStr));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 6];
        int current = 0;
        options[current++] = "-S";
        options[current++] = String.valueOf(this.m_Seed);
        options[current++] = "-I";
        options[current++] = String.valueOf(this.m_NumIterations);
        options[current++] = "-P";
        options[current++] = String.valueOf(this.m_BagSizePercent);
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }
}

