/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import weka.core.Utils;

public abstract class A {
    public static final int[] join(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        int i = 0;
        int j = 0;
        while (j < a.length) {
            c[i] = a[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < b.length) {
            c[i] = b[j];
            ++j;
            ++i;
        }
        return c;
    }

    public static final int[] reverse(int[] a) {
        int[] c = new int[a.length];
        int i = a.length - 1;
        int j = 0;
        while (i >= 0) {
            c[j] = a[i];
            --i;
            ++j;
        }
        return c;
    }

    public static final int[] sort(int[] a) {
        int[] c = Arrays.copyOf(a, a.length);
        Utils.sort((int[])c);
        return c;
    }

    public static String toString(double[] v) {
        return A.toString(v, 2);
    }

    public static String toString(double[] v, int adp) {
        if (adp <= 0) {
            return A.toString(A.toIntArray(v));
        }
        int w = adp + 2;
        StringBuilder sb = new StringBuilder("[ ");
        for (int k = 0; k < v.length; ++k) {
            sb.append(String.format("%" + w + "." + adp + "f ", v[k]));
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(int[] v) {
        StringBuilder sb = new StringBuilder("[ ");
        for (int k = 0; k < v.length; ++k) {
            sb.append(v[k]);
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static final double product(double[] v) {
        double p = 1.0;
        for (double d : v) {
            p *= d;
        }
        return p;
    }

    public static double sum(double[] v) {
        double p = 0.0;
        for (double d : v) {
            p += d;
        }
        return p;
    }

    public static int sum(int[] v) {
        int p = 0;
        for (int d : v) {
            p += d;
        }
        return p;
    }

    public static int mode(int[] a) {
        int max = 0;
        int count = 0;
        HashMap<Integer, Integer> d = new HashMap<Integer, Integer>();
        for (int v : a) {
            int n = d.containsKey(v) ? (Integer)d.get(v) + 1 : 1;
            d.put(v, n);
            if (n <= count) continue;
            max = v;
        }
        return max;
    }

    public static int[] append(int[] array, int v) {
        int n = array.length;
        array = Arrays.copyOf(array, n + 1);
        array[n] = v;
        return array;
    }

    public static int[] delete(int[] array, int i) {
        int n = array.length;
        array[i] = array[n - 1];
        array = Arrays.copyOf(array, n - 1);
        return array;
    }

    public static int[] delete(int[] array, int[] i) {
        for (int i_ : i) {
            array = A.delete(array, i_);
        }
        return array;
    }

    public static int[] select(int[] array, int[] indices) {
        int[] selection = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            selection[i] = array[indices[i]];
        }
        return selection;
    }

    public static int[] swap(int[] array, int j, int k) {
        int temp = array[j];
        array[j] = array[k];
        array[k] = temp;
        return array;
    }

    public static int[] swap(int[] array, Random r) {
        int b;
        int a;
        return A.swap(array, a, (a = r.nextInt(array.length)) == (b = r.nextInt(array.length - 1)) ? array.length - 1 : b);
    }

    public static int samplePMF(double[] w, Random r) {
        double u = r.nextDouble();
        int i = 0;
        for (double sum = w[0]; sum < u; sum += w[++i]) {
        }
        return i;
    }

    public static final int[] make_sequence(int L) {
        int[] ind = new int[L];
        for (int i = 0; i < L; ++i) {
            ind[i] = i;
        }
        return ind;
    }

    public static final int[] make_sequence(int start, int end) {
        int[] array = new int[end - start];
        int j = start;
        int i = 0;
        while (j < end) {
            array[i] = j++;
            ++i;
        }
        return array;
    }

    public static final int[] invert(int[] indices, int L) {
        int[] sindices = Arrays.copyOf(indices, indices.length);
        Arrays.sort(sindices);
        int[] inverted = new int[L - sindices.length];
        int i = 0;
        for (int j = 0; j < L; ++j) {
            if (Arrays.binarySearch(sindices, j) >= 0) continue;
            inverted[i++] = j;
        }
        return inverted;
    }

    public static final void shuffle(int[] array, Random r) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = r.nextInt(i + 1);
            int temp = array[index];
            array[index] = array[i];
            array[i] = temp;
        }
    }

    public static int[] toPrimitive(Integer[] a) {
        int[] b = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
        return b;
    }

    public static int[] toPrimitive(List<Integer> list) {
        int[] a = new int[list.size()];
        Iterator<Integer> iter = list.iterator();
        int i = 0;
        while (iter.hasNext()) {
            a[i] = iter.next();
            ++i;
        }
        return a;
    }

    public static final double[] toDoubleArray(int[] z) {
        double[] y = new double[z.length];
        for (int j = 0; j < z.length; ++j) {
            y[j] = z[j];
        }
        return y;
    }

    public static final int[] toIntArray(String s) {
        int[] array = new int[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            array[i] = Character.digit(s.charAt(i), 10);
        }
        return array;
    }

    public static final int[] toIntArray(String[] s) {
        int[] u = new int[s.length];
        for (int j = 0; j < s.length; ++j) {
            u[j] = Integer.parseInt(s[j]);
        }
        return u;
    }

    public static final int[] toIntArray(double[] z) {
        int[] u = new int[z.length];
        for (int j = 0; j < z.length; ++j) {
            u[j] = (int)z[j];
        }
        return u;
    }

    public static final int[] toIntArray(double[] z, double t) {
        int[] u = new int[z.length];
        for (int j = 0; j < z.length; ++j) {
            u[j] = z[j] > t ? 1 : 0;
        }
        return u;
    }

    public static final double[] toDoubleArray(int i, int L) {
        double[] u = new double[L];
        if (i == 0) {
            return u;
        }
        String s = Integer.toBinaryString(i);
        for (int j = 0; j < s.length(); ++j) {
            u[j] = Integer.parseInt(String.valueOf(s.charAt(j)));
        }
        return u;
    }
}

