/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.util.ArrayList;
import java.util.Iterator;
import meka.core.A;
import meka.core.M;
import weka.core.Utils;

public abstract class Metrics {
    public static double P_ExactMatch(int[][] Y, int[][] Ypred) {
        return 1.0 - Metrics.L_ZeroOne(Y, Ypred);
    }

    public static double L_ZeroOne(int[] y, int[] ypred) {
        int L = y.length;
        for (int j = 0; j < L; ++j) {
            if (y[j] == ypred[j]) continue;
            return 1.0;
        }
        return 0.0;
    }

    public static double L_ZeroOne(int[][] Y, int[][] Ypred) {
        int N = Y.length;
        double loss = 0.0;
        for (int i = 0; i < Y.length; ++i) {
            loss += Metrics.L_ZeroOne(Y[i], Ypred[i]);
        }
        return loss / (double)N;
    }

    public static double L_Hamming(int[] y, int[] ypred) {
        int L = y.length;
        double loss = 0.0;
        for (int j = 0; j < L; ++j) {
            if (y[j] == ypred[j]) continue;
            loss += 1.0;
        }
        return loss / (double)L;
    }

    public static double L_Hamming(int[][] Y, int[][] Ypred) {
        int N = Y.length;
        double loss = 0.0;
        for (int i = 0; i < Y.length; ++i) {
            loss += Metrics.L_Hamming(Y[i], Ypred[i]);
        }
        return loss / (double)N;
    }

    public static double P_Hamming(int[][] Y, int[][] Ypred) {
        return 1.0 - Metrics.L_Hamming(Y, Ypred);
    }

    public static double P_Hamming(int[][] Y, int[][] Ypred, int j) {
        int[] y_j = M.getCol(Y, j);
        int[] ypred_j = M.getCol(Ypred, j);
        return 1.0 - Metrics.L_Hamming(y_j, ypred_j);
    }

    public static double P_Harmonic(int[] y, int[] ypred) {
        int L = y.length;
        double[] acc = new double[2];
        double[] N = new double[2];
        for (int j = 0; j < L; ++j) {
            int n = y[j];
            N[n] = N[n] + 1.0;
            if (y[j] != ypred[j]) continue;
            int n2 = y[j];
            acc[n2] = acc[n2] + 1.0;
        }
        for (int v = 0; v < 2; ++v) {
            acc[v] = acc[v] / N[v];
        }
        return 2.0 / (1.0 / acc[0] + 1.0 / acc[1]);
    }

    public static double P_Harmonic(int[][] Y, int[][] Ypred, int j) {
        int[] y_j = M.getCol(Y, j);
        int[] ypred_j = M.getCol(Ypred, j);
        return Metrics.P_Harmonic(y_j, ypred_j);
    }

    public static double P_Harmonic(int[][] Y, int[][] Ypred) {
        int N = Y.length;
        double loss = 0.0;
        for (int i = 0; i < Y.length; ++i) {
            loss += Metrics.P_Harmonic(Y[i], Ypred[i]);
        }
        return loss / (double)N;
    }

    public static double P_Accuracy(int[] y, int[] ypred) {
        int L = y.length;
        int set_union = 0;
        int set_inter = 0;
        for (int j = 0; j < L; ++j) {
            if (y[j] == 1 || ypred[j] == 1) {
                ++set_union;
            }
            if (y[j] != 1 || ypred[j] != 1) continue;
            ++set_inter;
        }
        return set_union > 0 ? (double)set_inter / (double)set_union : 1.0;
    }

    public static double P_Accuracy(int[][] Y, int[][] Ypred) {
        int N = Y.length;
        double accuracy = 0.0;
        for (int i = 0; i < Y.length; ++i) {
            accuracy += Metrics.P_Accuracy(Y[i], Ypred[i]);
        }
        return accuracy / (double)N;
    }

    public static double P_JaccardIndex(int[][] Y, int[][] Ypred) {
        return Metrics.P_Accuracy(Y, Ypred);
    }

    public static double L_JaccardDist(int[][] Y, int[][] Ypred) {
        return 1.0 - Metrics.P_Accuracy(Y, Ypred);
    }

    public static double L_LogLoss(double y, double rpred, double C) {
        double ans = Math.min(Utils.eq((double)y, (double)rpred) ? 0.0 : -(y * Math.log(rpred) + (1.0 - y) * Math.log(1.0 - rpred)), C);
        return Double.isNaN(ans) ? 0.0 : ans;
    }

    public static double L_LogLossL(int[][] Y, double[][] Rpred) {
        int N = Y.length;
        int L = Y[0].length;
        return Metrics.L_LogLoss(Y, Rpred, Math.log(L)) / ((double)N * (double)L);
    }

    public static double L_LogLossD(int[][] Y, double[][] Rpred) {
        int N = Y.length;
        int L = Y[0].length;
        return Metrics.L_LogLoss(Y, Rpred, Math.log(N)) / ((double)N * (double)L);
    }

    public static double L_LogLoss(int[][] Y, double[][] Rpred, double C) {
        double loss = 0.0;
        for (int i = 0; i < Y.length; ++i) {
            for (int j = 0; j < Y[i].length; ++j) {
                loss += Metrics.L_LogLoss(Y[i][j], Rpred[i][j], C);
            }
        }
        return loss;
    }

    public static double P_TruePositives(int[] y, int[] ypred) {
        int s = 0;
        for (int j = 0; j < y.length; ++j) {
            if (ypred[j] != 1 || y[j] != 1) continue;
            ++s;
        }
        return s;
    }

    public static double P_FalsePositives(int[] y, int[] ypred) {
        int s = 0;
        for (int j = 0; j < y.length; ++j) {
            if (ypred[j] != 1 || y[j] != 0) continue;
            ++s;
        }
        return s;
    }

    public static double P_TrueNegatives(int[] y, int[] ypred) {
        int s = 0;
        for (int j = 0; j < y.length; ++j) {
            if (ypred[j] != 0 || y[j] != 0) continue;
            ++s;
        }
        return s;
    }

    public static double P_FalseNegatives(int[] y, int[] ypred) {
        int s = 0;
        for (int j = 0; j < y.length; ++j) {
            if (ypred[j] != 0 || y[j] != 1) continue;
            ++s;
        }
        return s;
    }

    public static double P_Precision(int[] y, int[] ypred) {
        double tp = Metrics.P_TruePositives(y, ypred);
        double fp = Metrics.P_FalsePositives(y, ypred);
        if (tp == 0.0 && fp == 0.0) {
            return 0.0;
        }
        return tp / (tp + fp);
    }

    public static double P_Recall(int[] y, int[] ypred) {
        double tp = Metrics.P_TruePositives(y, ypred);
        double fn = Metrics.P_FalseNegatives(y, ypred);
        if (tp == 0.0 && fn == 0.0) {
            return 0.0;
        }
        return tp / (tp + fn);
    }

    public static double F1(int[] s1, int[] s2) {
        double p = Metrics.P_Precision(s1, s2);
        double r = Metrics.P_Recall(s1, s2);
        if (p == 0.0 && r == 0.0) {
            return 0.0;
        }
        return 2.0 * p * r / (p + r);
    }

    public static double P_Precision(int[][] Y, int[][] Ypred, int j) {
        return Metrics.P_Precision(M.getCol(Y, j), M.getCol(Ypred, j));
    }

    public static double P_Recall(int[][] Y, int[][] Ypred, int j) {
        return Metrics.P_Recall(M.getCol(Y, j), M.getCol(Ypred, j));
    }

    public static double P_FmicroAvg(int[][] Y, int[][] Ypred) {
        return Metrics.F1(M.flatten(Y), M.flatten(Ypred));
    }

    public static double P_FmacroAvgL(int[][] Y, int[][] Ypred) {
        int L = Y[0].length;
        double[] TP = new double[L];
        double[] FP = new double[L];
        double[] FN = new double[L];
        double[] F2 = new double[L];
        for (int j = 0; j < L; ++j) {
            int[] y_j = M.getCol(Y, j);
            int[] ypred_j = M.getCol(Ypred, j);
            TP[j] = Metrics.P_TruePositives(y_j, ypred_j);
            FP[j] = Metrics.P_FalsePositives(y_j, ypred_j);
            FN[j] = Metrics.P_FalseNegatives(y_j, ypred_j);
            if (TP[j] <= 0.0) {
                F2[j] = 0.0;
                continue;
            }
            double prec = TP[j] / (TP[j] + FP[j]);
            double recall = TP[j] / (TP[j] + FN[j]);
            F2[j] = 2.0 * (prec * recall / (prec + recall));
        }
        return A.sum(F2) / (double)L;
    }

    public static double P_FmacroAvgD(int[][] Y, int[][] Ypred) {
        int N = Y.length;
        double F1_macro_D = 0.0;
        for (int i = 0; i < N; ++i) {
            F1_macro_D += Metrics.F1(Y[i], Ypred[i]);
        }
        return F1_macro_D / (double)N;
    }

    public static double L_OneError(int[][] Y, double[][] Rpred) {
        int N = Y.length;
        int one_error = 0;
        for (int i = 0; i < N; ++i) {
            if (Y[i][Utils.maxIndex((double[])Rpred[i])] > 0) continue;
            ++one_error;
        }
        return (double)one_error / (double)N;
    }

    public static double P_AveragePrecision(int[][] Y, double[][] Rpred) {
        double loss = 0.0;
        for (int i = 0; i < Y.length; ++i) {
            loss += Metrics.P_AveragePrecision(Y[i], Rpred[i]);
        }
        return loss / (double)Y.length;
    }

    public static double P_AveragePrecision(int[] y, double[] rpred) {
        int[] r = Utils.sort((double[])rpred);
        return Metrics.P_AveragePrecision(y, r);
    }

    public static double P_AveragePrecision(int[] y, int[] r) {
        double avg_prec = 0.0;
        int L = y.length;
        ArrayList<Integer> ones = new ArrayList<Integer>();
        for (int j = 0; j < L; ++j) {
            if (y[j] != 1) continue;
            ones.add(j);
        }
        if (ones.size() <= 0) {
            return 1.0;
        }
        Iterator i$ = ones.iterator();
        while (i$.hasNext()) {
            int j = (Integer)i$.next();
            double s = 0.0;
            Iterator i$2 = ones.iterator();
            while (i$2.hasNext()) {
                int k = (Integer)i$2.next();
                if (r[k] > r[j]) continue;
                s += 1.0;
            }
            avg_prec += s / (1.0 + (double)r[j]);
        }
        return avg_prec /= (double)ones.size();
    }

    public static double L_RankLoss(int[][] Y, double[][] Rpred) {
        double loss = 0.0;
        for (int i = 0; i < Y.length; ++i) {
            loss += Metrics.L_RankLoss(Y[i], Rpred[i]);
        }
        return loss / (double)Y.length;
    }

    public static double L_RankLoss(int[] y, double[] rpred) {
        int[] r = Utils.sort((double[])rpred);
        return Metrics.L_RankLoss(y, r);
    }

    public static double L_RankLoss(int[] y, int[] r) {
        int L = y.length;
        ArrayList<Integer> tI = new ArrayList<Integer>();
        ArrayList<Integer> fI = new ArrayList<Integer>();
        for (int j = 0; j < L; ++j) {
            if (y[j] == 1) {
                tI.add(j);
                continue;
            }
            fI.add(j);
        }
        if (!tI.isEmpty() && !fI.isEmpty()) {
            int c = 0;
            Iterator i$ = tI.iterator();
            while (i$.hasNext()) {
                int k = (Integer)i$.next();
                Iterator i$2 = fI.iterator();
                while (i$2.hasNext()) {
                    int l = (Integer)i$2.next();
                    if (Metrics.position(k, r) >= Metrics.position(l, r)) continue;
                    ++c;
                }
            }
            return (double)c / (double)(tI.size() * fI.size());
        }
        return 0.0;
    }

    private static int position(int index, int[] r) {
        int i = 0;
        while (r[i] != index) {
            ++i;
        }
        return i;
    }

    public double P_LogLikelihood(int[] y, double[] p) {
        int L = y.length;
        double l = 0.0;
        for (int j = 0; j < L; ++j) {
            l += Math.log(Math.pow(p[j], y[j]) * Math.pow(1.0 - p[j], 1 - y[j]));
        }
        return l;
    }

    public double L_MSE(int[] y, double[] p) {
        int L = y.length;
        double[] l = new double[L];
        for (int j = 0; j < L; ++j) {
            l[j] = Math.pow(p[j] - (double)y[j], 2.0);
        }
        return A.product(l);
    }

    public double L_MAE(int[] y, double[] p) {
        int L = y.length;
        double[] l = new double[L];
        for (int j = 0; j < L; ++j) {
            l[j] = Math.abs(p[j] - (double)y[j]);
        }
        return A.product(l);
    }

    public static void main(String[] args) {
        int[][] Y = new int[][]{{0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}};
        int[][] Ypred = new int[][]{{0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        System.out.println("0.533333333... = " + Metrics.P_FmacroAvgD(Y, Ypred));
    }
}

