/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.io.File;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import weka.core.Utils;

public class PropsUtils {
    public static boolean DEBUG = false;

    public static Properties read(String props) throws Exception {
        Properties result = Utils.readProperties((String)props);
        if (DEBUG) {
            System.out.println("start<PropsUtils.read: " + props + ">\n" + PropsUtils.toString(result, null) + "end<PropsUtils.read: " + props + ">\n");
        }
        return result;
    }

    public static URL[] find(String props) {
        if (DEBUG) {
            System.out.println("start<PropsUtils.find: " + props + ">");
        }
        ArrayList<URL> result = new ArrayList<URL>();
        String propsName = new File(props).getName();
        if (DEBUG) {
            System.out.println("- propsName: " + propsName);
        }
        try {
            if (DEBUG) {
                System.out.println("1. system resources: ");
            }
            Enumeration<URL> urls = ClassLoader.getSystemResources(props);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (DEBUG) {
                    System.out.println("- " + url);
                }
                result.add(url);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to obtain systems resources (URLs) for: " + props);
        }
        if (DEBUG) {
            System.out.println("2. home dir: " + System.getProperty("user.home"));
        }
        File propsFile = new File(System.getProperty("user.home") + File.separator + propsName);
        if (DEBUG) {
            System.out.println("- propsFile: " + propsFile);
            System.out.println("- propsFile exists: " + propsFile.exists());
        }
        if (propsFile.exists()) {
            try {
                result.add(propsFile.toURL());
            }
            catch (Exception e) {
                System.err.println("Failed to turn '" + propsFile + "' into URL:");
                e.printStackTrace();
            }
        }
        if (DEBUG) {
            System.out.println("3. current dir: " + System.getProperty("user.dir"));
        }
        propsFile = new File(System.getProperty("user.dir") + File.separator + propsName);
        if (DEBUG) {
            System.out.println("- propsFile: " + propsFile);
            System.out.println("- propsFile exists: " + propsFile.exists());
        }
        if (propsFile.exists()) {
            try {
                result.add(propsFile.toURL());
            }
            catch (Exception e) {
                System.err.println("Failed to turn '" + propsFile + "' into URL:");
                e.printStackTrace();
            }
        }
        if (DEBUG) {
            System.out.println("end<PropsUtils.find: " + props + ">");
        }
        return result.toArray(new URL[result.size()]);
    }

    public static Properties collapse(Properties props) {
        Properties result = new Properties();
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            result.setProperty(key, props.getProperty(key));
        }
        return result;
    }

    public static String toString(Properties props, String comment) {
        String result = null;
        try {
            StringWriter writer = new StringWriter();
            PropsUtils.collapse(props).store(writer, comment);
            writer.flush();
            writer.close();
            result = writer.toString();
        }
        catch (Exception e) {
            result = null;
            System.err.println("Failed to turn props into string: " + props);
            e.printStackTrace();
        }
        return result;
    }

    protected static void printUsage() {
        System.out.println("Usage: " + PropsUtils.class.getName() + " <read|find> <props>");
        System.out.println("Use uppercase of read/find to enable debug output");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("- read");
        System.out.println("  " + PropsUtils.class.getName() + " read meka/gui/goe/MekaEditors.props");
        System.out.println("- find");
        System.out.println("  " + PropsUtils.class.getName() + " find meka/gui/goe/MekaEditors.props");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            if (args[0].toLowerCase().equals("read")) {
                if (args[0].equals("READ")) {
                    DEBUG = true;
                }
                Properties props = PropsUtils.read(args[1]);
                System.out.println(PropsUtils.toString(props, null));
            } else if (args[0].toLowerCase().equals("find")) {
                URL[] urls;
                if (args[0].equals("FIND")) {
                    DEBUG = true;
                }
                for (URL url : urls = PropsUtils.find(args[1])) {
                    System.out.println(url);
                }
            } else {
                PropsUtils.printUsage();
            }
        } else {
            PropsUtils.printUsage();
        }
    }
}

