/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import meka.core.MLUtils;

public abstract class ThresholdUtils {
    public static double[] thresholdStringToArray(String top, int L) {
        if (top.startsWith("[")) {
            return MLUtils.toDoubleArray(top);
        }
        double[] t = new double[L];
        Arrays.fill(t, Double.parseDouble(top));
        return t;
    }

    public static double calibrateThreshold(ArrayList<double[]> Y, double LC_train) {
        if (Y.size() <= 0) {
            return 0.5;
        }
        int N = Y.size();
        ArrayList<Double> big = new ArrayList<Double>();
        for (double[] y : Y) {
            for (double y_ : y) {
                big.add(y_);
            }
        }
        Collections.sort(big);
        int i = big.size() - (int)Math.round(LC_train * (double)N);
        if (N == big.size()) {
            if (i + 1 == N) {
                return (Double)big.get(N - 2) + (Double)big.get(N - 1) / 2.0;
            }
            if (i + 1 >= N) {
                return 1.0;
            }
            return Math.max(((Double)big.get(i) + (Double)big.get(i + 1)) / 2.0, 1.0E-5);
        }
        return Math.max(((Double)big.get(i) + (Double)big.get(Math.max(i + 1, N - 1))) / 2.0, 1.0E-5);
    }

    public static double[] calibrateThresholds(ArrayList<double[]> Y, double[] LC_train) {
        int L = LC_train.length;
        double[] t = new double[L];
        ArrayList[] Y_ = new ArrayList[L];
        for (int j = 0; j < L; ++j) {
            Y_[j] = new ArrayList();
        }
        for (double[] y : Y) {
            for (int j = 0; j < L; ++j) {
                Y_[j].add(new double[]{y[j]});
            }
        }
        for (int j = 0; j < L; ++j) {
            t[j] = ThresholdUtils.calibrateThreshold(Y_[j], LC_train[j]);
        }
        return t;
    }

    public static final int[][] threshold(double[][] Rpred, double[] t) {
        int[][] Ypred = new int[Rpred.length][Rpred[0].length];
        for (int i = 0; i < Rpred.length; ++i) {
            for (int j = 0; j < Rpred[i].length; ++j) {
                Ypred[i][j] = Rpred[i][j] >= t[j] ? 1 : 0;
            }
        }
        return Ypred;
    }

    public static final int[][] threshold(double[][] Rpred, double t) {
        int[][] Ypred = new int[Rpred.length][Rpred[0].length];
        for (int i = 0; i < Rpred.length; ++i) {
            for (int j = 0; j < Rpred[i].length; ++j) {
                Ypred[i][j] = Rpred[i][j] >= t ? 1 : 0;
            }
        }
        return Ypred;
    }

    public static final int[] threshold(double[] rpred, String ts) {
        int L = rpred.length;
        double[] t = ThresholdUtils.thresholdStringToArray(ts, L);
        int[] ypred = new int[L];
        for (int j = 0; j < L; ++j) {
            ypred[j] = rpred[j] >= t[j] ? 1 : 0;
        }
        return ypred;
    }

    public static final int[][] round(double[][] Rpred) {
        int[][] Ypred = new int[Rpred.length][Rpred[0].length];
        for (int i = 0; i < Rpred.length; ++i) {
            for (int j = 0; j < Rpred[i].length; ++j) {
                Ypred[i][j] = (int)Math.round(Rpred[i][j]);
            }
        }
        return Ypred;
    }
}

