/*
 * Decompiled with CFR 0.152.
 */
package meka.experiment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import meka.core.MLUtils;
import meka.experiment.MekaResultProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaPackageManager;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.xml.KOML;
import weka.core.xml.XMLOptions;
import weka.experiment.Experiment;
import weka.experiment.xml.XMLExperiment;

public class MekaExperiment
extends Experiment {
    static final long serialVersionUID = 44945596742646663L;
    protected int m_TotalNumClasses = 0;

    public void initialize() throws Exception {
        this.m_TotalNumClasses = 0;
        for (int i = 0; i < this.getDatasets().getSize(); ++i) {
            int numClasses = MLUtils.peekClassIndex((File)this.getDatasets().getElementAt(i));
            this.m_TotalNumClasses = Math.max(this.m_TotalNumClasses, numClasses);
        }
        System.err.println("Total number of classes: " + this.m_TotalNumClasses);
        if (this.m_ResultProducer instanceof MekaResultProducer) {
            ((MekaResultProducer)this.m_ResultProducer).setTotalNumClasses(this.m_TotalNumClasses);
        }
        super.initialize();
    }

    public void nextIteration() throws Exception {
        if (this.m_UsePropertyIterator && this.m_CurrentProperty != this.m_PropertyNumber) {
            this.setProperty(0, this.m_ResultProducer);
            this.m_CurrentProperty = this.m_PropertyNumber;
        }
        if (this.m_CurrentInstances == null) {
            File currentFile = (File)this.getDatasets().elementAt(this.m_DatasetNumber);
            AbstractFileLoader loader = ConverterUtils.getLoaderForFile((File)currentFile);
            loader.setFile(currentFile);
            Instances data = new Instances(loader.getDataSet());
            MLUtils.prepareData(data);
            this.m_CurrentInstances = data;
            this.m_ResultProducer.setInstances(this.m_CurrentInstances);
        }
        this.m_ResultProducer.doRun(this.m_RunNumber);
        this.advanceCounters();
    }

    public static MekaExperiment read(String filename) throws Exception {
        MekaExperiment result;
        if (KOML.isPresent() && filename.toLowerCase().endsWith(".koml")) {
            result = (MekaExperiment)((Object)KOML.read((String)filename));
        } else if (filename.toLowerCase().endsWith(".xml")) {
            XMLExperiment xml = new XMLExperiment();
            result = (MekaExperiment)((Object)xml.read(filename));
        } else {
            FileInputStream fi = new FileInputStream(filename);
            ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(fi));
            result = (MekaExperiment)((Object)oi.readObject());
            oi.close();
        }
        return result;
    }

    public static void write(String filename, MekaExperiment exp) throws Exception {
        if (KOML.isPresent() && filename.toLowerCase().endsWith(".koml")) {
            KOML.write((String)filename, (Object)((Object)exp));
        } else if (filename.toLowerCase().endsWith(".xml")) {
            XMLExperiment xml = new XMLExperiment();
            xml.write(filename, (Object)exp);
        } else {
            FileOutputStream fo = new FileOutputStream(filename);
            ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(fo));
            oo.writeObject((Object)exp);
            oo.close();
        }
    }

    public static void main(String[] args) {
        try {
            WekaPackageManager.loadPackages((boolean)false);
            MekaExperiment exp = null;
            String xmlOption = Utils.getOption((String)"xml", (String[])args);
            if (!xmlOption.equals("")) {
                args = new XMLOptions(xmlOption).toArray();
            }
            String expFile = Utils.getOption((char)'l', (String[])args);
            String saveFile = Utils.getOption((char)'s', (String[])args);
            boolean runExp = Utils.getFlag((char)'r', (String[])args);
            boolean verbose = Utils.getFlag((String)"verbose", (String[])args);
            if (expFile.length() == 0) {
                exp = new MekaExperiment();
                try {
                    exp.setOptions(args);
                    Utils.checkForRemainingOptions((String[])args);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    String result = "Usage:\n\n-l <exp|xml file>\n\tLoad experiment from file (default use cli options).\n\tThe type is determined, based on the extension (" + FILE_EXTENSION + " or .xml)\n" + "-s <exp|xml file>\n" + "\tSave experiment to file after setting other options.\n" + "\tThe type is determined, based on the extension (" + FILE_EXTENSION + " or .xml)\n" + "\t(default don't save)\n" + "-r\n" + "\tRun experiment (default don't run)\n" + "-xml <filename | xml-string>\n" + "\tget options from XML-Data instead from parameters.\n" + "-verbose\n" + "\toutput progress information to std out." + "\n";
                    Enumeration enm = exp.listOptions();
                    while (enm.hasMoreElements()) {
                        Option option = (Option)enm.nextElement();
                        result = result + option.synopsis() + "\n";
                        result = result + option.description() + "\n";
                    }
                    throw new Exception(result + "\n" + ex.getMessage());
                }
            } else {
                String dataName;
                exp = MekaExperiment.read(expFile);
                do {
                    if ((dataName = Utils.getOption((char)'T', (String[])args)).length() == 0) continue;
                    File dataset = new File(dataName);
                    exp.getDatasets().addElement(dataset);
                } while (dataName.length() != 0);
            }
            System.err.println("Experiment:\n" + exp.toString());
            if (saveFile.length() != 0) {
                MekaExperiment.write(saveFile, exp);
            }
            if (runExp) {
                System.err.println("Initializing...");
                exp.initialize();
                System.err.println("Iterating...");
                exp.runExperiment(verbose);
                System.err.println("Postprocessing...");
                exp.postProcess();
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10376 $");
    }
}

