/*
 * Decompiled with CFR 0.152.
 */
package meka.gui.core;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.net.URL;
import javax.swing.ImageIcon;

public class GUIHelper {
    public static final String IMAGE_DIR = "meka/gui/images/";
    public static final String EMPTY_ICON = "empty.gif";
    public static final char MNEMONIC_INDICATOR = '_';

    public static boolean hasImageFile(String name) {
        return GUIHelper.getImageFilename(name) != null;
    }

    public static String getImageFilename(String name) {
        String result = null;
        try {
            URL url = ClassLoader.getSystemClassLoader().getResource(IMAGE_DIR + name);
            if (url != null) {
                result = IMAGE_DIR + name;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static ImageIcon getIcon(Class cls) {
        if (GUIHelper.hasImageFile(cls.getName() + ".gif")) {
            return GUIHelper.getIcon(cls.getName() + ".gif");
        }
        if (GUIHelper.hasImageFile(cls.getName() + ".png")) {
            return GUIHelper.getIcon(cls.getName() + ".png");
        }
        if (GUIHelper.hasImageFile(cls.getName() + ".jpg")) {
            return GUIHelper.getIcon(cls.getName() + ".jpg");
        }
        return null;
    }

    public static ImageIcon getIcon(String name) {
        String filename = GUIHelper.getImageFilename(name);
        if (filename != null) {
            return new ImageIcon(ClassLoader.getSystemClassLoader().getResource(filename));
        }
        return null;
    }

    public static ImageIcon getExternalIcon(String filename) {
        ImageIcon result;
        try {
            result = new ImageIcon(ClassLoader.getSystemClassLoader().getResource(filename));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static ImageIcon getEmptyIcon() {
        return GUIHelper.getIcon(EMPTY_ICON);
    }

    public static ImageIcon getLogoImage() {
        return GUIHelper.getIcon("MEKA.png");
    }

    public static ImageIcon getLogoIcon() {
        return GUIHelper.getIcon("MEKA_icon.png");
    }

    public static Font getMonospacedFont() {
        return new Font("monospaced", 0, 12);
    }

    public static Object getParent(Container cont, Class parentClass) {
        Container result = null;
        for (Container parent = cont; parent != null; parent = parent.getParent()) {
            if (!parentClass.isInstance(parent)) continue;
            result = parent;
            break;
        }
        return result;
    }

    public static Frame getParentFrame(Container cont) {
        return (Frame)GUIHelper.getParent(cont, Frame.class);
    }

    public static Dialog getParentDialog(Container cont) {
        return (Dialog)GUIHelper.getParent(cont, Dialog.class);
    }

    public static char getMnemonic(String caption) {
        int pos = caption.indexOf(95);
        if (pos > -1 && pos < caption.length() - 1) {
            return caption.charAt(pos + 1);
        }
        return '\u0000';
    }
}

