/*
 * Decompiled with CFR 0.152.
 */
package meka.gui.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import meka.core.Result;

public class ResultHistory
implements Serializable {
    private static final long serialVersionUID = -2806420567531406970L;
    protected Hashtable<Date, Result> m_Results = new Hashtable();
    protected Hashtable<Date, String> m_Suffixes = new Hashtable();
    protected ArrayList<Date> m_Ordered = new ArrayList();

    public synchronized void clear() {
        this.m_Results.clear();
        this.m_Suffixes.clear();
        this.m_Ordered.clear();
    }

    public synchronized int size() {
        return this.m_Ordered.size();
    }

    public synchronized Result get(int index) {
        return this.m_Results.get(this.m_Ordered.get(index));
    }

    public synchronized Date getTimestamp(int index) {
        return this.m_Ordered.get(index);
    }

    public synchronized String getSuffix(int index) {
        return this.m_Suffixes.get(this.m_Ordered.get(index));
    }

    public synchronized void add(Result result, String suffix) {
        Date date = new Date();
        this.m_Results.put(date, result);
        this.m_Suffixes.put(date, suffix);
        this.m_Ordered.add(date);
    }

    public synchronized Result remove(int index) {
        Date date = this.m_Ordered.remove(index);
        this.m_Suffixes.remove(date);
        Result result = this.m_Results.remove(date);
        return result;
    }

    public synchronized String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (Date date : this.m_Ordered) {
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append(date);
            result.append(":");
            result.append(this.m_Suffixes.get(date));
            result.append("=");
            result.append(this.m_Results.get(date));
        }
        result.append("]");
        return result.toString();
    }
}

