/*
 * Decompiled with CFR 0.152.
 */
package meka.gui.core;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;
import meka.core.Result;
import meka.gui.core.MouseUtils;
import meka.gui.core.ResultHistory;
import weka.gui.ExtensionFileFilter;

public class ResultHistoryList
extends JList {
    private static final long serialVersionUID = 8655627570641911582L;
    protected JFileChooser m_FileChooser;

    public ResultHistoryList() {
        super(new ResultHistoryModel());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    JPopupMenu menu = ResultHistoryList.this.createPopup(e);
                    if (menu != null) {
                        menu.show(ResultHistoryList.this, e.getX(), e.getY());
                    }
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int[] indices = ResultHistoryList.this.getSelectedIndices();
                if (indices.length > 0 && e.getKeyCode() == 127) {
                    for (int i = indices.length - 1; i >= 0; --i) {
                        ResultHistoryList.this.removeItem(indices[i]);
                    }
                    e.consume();
                } else {
                    super.keyTyped(e);
                }
            }
        });
        this.m_FileChooser = new JFileChooser(System.getProperty("user.home"));
        ExtensionFileFilter filter = new ExtensionFileFilter("txt", "Meka results format (*.txt)");
        this.m_FileChooser.addChoosableFileFilter((FileFilter)filter);
        this.m_FileChooser.setFileFilter((FileFilter)filter);
        this.m_FileChooser.setMultiSelectionEnabled(false);
    }

    protected JPopupMenu createPopup(MouseEvent e) {
        JPopupMenu result = null;
        final int index = this.locationToIndex(e.getPoint());
        if (index == -1) {
            return null;
        }
        Rectangle rect = this.getCellBounds(index, index);
        if (!rect.contains(e.getPoint())) {
            return null;
        }
        result = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Save...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultHistoryList.this.save(index);
            }
        });
        result.add(menuitem);
        result.addSeparator();
        menuitem = new JMenuItem("Remove");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultHistoryList.this.removeItem(index);
            }
        });
        result.add(menuitem);
        menuitem = new JMenuItem("Remove all");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ResultHistoryModel)ResultHistoryList.this.getModel()).clear();
            }
        });
        result.add(menuitem);
        return result;
    }

    protected boolean save(int index) {
        boolean result;
        int retVal = this.m_FileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return false;
        }
        File file = this.m_FileChooser.getSelectedFile();
        Result res = this.getResultAt(index);
        try {
            Result.writeResultToFile(res, file.getAbsolutePath());
            result = true;
        }
        catch (Exception e) {
            result = false;
            System.err.println("Failed to write result to file '" + file + "':");
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Failed to write result to file '" + file + "':\n" + e, "Error saving", 0);
        }
        return result;
    }

    protected void removeItem(int index) {
        ((ResultHistoryModel)this.getModel()).removeElementAt(index);
        if (index >= this.getModel().getSize()) {
            --index;
        }
        if (index >= 0) {
            this.setSelectedIndex(index);
        }
    }

    protected Date getTimestampAt(int index) {
        return (Date)((ResultHistoryModel)this.getModel()).getElementAt(index);
    }

    public void addResult(Result result, String suffix) {
        ((ResultHistoryModel)this.getModel()).addElement(result, suffix);
        this.setSelectedIndex(this.getModel().getSize() - 1);
    }

    public Result getResultAt(int index) {
        return ((ResultHistoryModel)this.getModel()).getResultAt(index);
    }

    public String getSuffixAt(int index) {
        return ((ResultHistoryModel)this.getModel()).getSuffixAt(index);
    }

    public void setModel(ListModel model) {
        if (!(model instanceof ResultHistoryModel)) {
            throw new IllegalArgumentException("Model is not derived from " + ResultHistoryModel.class.getName() + "!");
        }
        super.setModel(model);
    }

    public static class ResultHistoryModel
    extends AbstractListModel {
        private static final long serialVersionUID = -9179459138851904317L;
        protected ResultHistory m_History;

        public ResultHistoryModel() {
            this(new ResultHistory());
        }

        public ResultHistoryModel(ResultHistory history) {
            this.m_History = history;
        }

        public void clear() {
            int to = this.m_History.size();
            this.m_History.clear();
            this.fireIntervalRemoved(this, 0, to);
        }

        @Override
        public int getSize() {
            return this.m_History.size();
        }

        public void addElement(Result result, String suffix) {
            this.m_History.add(result, suffix);
            this.fireIntervalAdded(this, this.m_History.size() - 1, this.m_History.size() - 1);
        }

        @Override
        public Object getElementAt(int index) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String element = formatter.format(this.getTimestampAt(index));
            String suffix = this.getSuffixAt(index);
            if (suffix != null && suffix.trim().length() > 0) {
                element = element + ": " + suffix;
            }
            return element;
        }

        public Date getTimestampAt(int index) {
            return this.m_History.getTimestamp(index);
        }

        public Result getResultAt(int index) {
            return this.m_History.get(index);
        }

        public String getSuffixAt(int index) {
            return this.m_History.getSuffix(index);
        }

        public Result removeElementAt(int index) {
            Result result = this.m_History.remove(index);
            this.fireIntervalRemoved(this, index, index);
            return result;
        }

        public ResultHistory getHistory() {
            return this.m_History;
        }
    }
}

