/*
 * Decompiled with CFR 0.152.
 */
package meka.gui.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import meka.gui.core.GUIHelper;
import meka.gui.core.MekaPanel;

public class StatusBar
extends MekaPanel {
    private static final long serialVersionUID = 2942070600827649700L;
    protected JLabel m_LabelText;
    protected JPanel m_PanelText;
    protected JPanel m_PanelIcon;
    protected JLabel m_LabelIcon;
    protected Animation m_Animation;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelText = new JPanel(new FlowLayout(0));
        this.m_LabelText = new JLabel(" ");
        this.m_PanelText.add(this.m_LabelText);
        this.m_PanelText.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.m_PanelText, "Center");
        this.m_PanelIcon = new JPanel(new BorderLayout());
        this.m_LabelIcon = new JLabel(GUIHelper.getIcon("MEKA_icon_animated1.png"));
        this.m_PanelIcon.add((Component)this.m_LabelIcon, "Center");
        this.m_PanelIcon.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.m_PanelIcon, "East");
        this.m_PanelIcon.setMinimumSize(new Dimension(22, 22));
    }

    public void showStatus(String msg) {
        if (msg == null || msg.isEmpty()) {
            msg = " ";
        }
        this.m_LabelText.setText(msg);
    }

    public void clearStatus() {
        this.showStatus("");
    }

    protected Runnable createAnimation() {
        return new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    public void startBusy() {
        if (this.m_Animation != null) {
            return;
        }
        this.m_Animation = new Animation(this.m_LabelIcon, 1000);
        new Thread(this.m_Animation).start();
    }

    public void startBusy(String msg) {
        this.showStatus(msg);
        this.startBusy();
    }

    public void finishBusy() {
        if (this.m_Animation == null) {
            return;
        }
        this.m_Animation.stopAnimation();
        this.m_Animation = null;
    }

    public void finishBusy(String msg) {
        this.showStatus(msg);
        this.finishBusy();
    }

    public static class Animation
    implements Runnable {
        protected JLabel m_LabelIcon;
        protected boolean m_Running;
        protected int m_Delay;

        public Animation(JLabel labelIcon, int delay) {
            this.m_LabelIcon = labelIcon;
            this.m_Delay = delay;
        }

        protected void show(final int index) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    Animation.this.m_LabelIcon.setIcon(GUIHelper.getIcon("MEKA_icon_animated" + index + ".png"));
                }
            };
            SwingUtilities.invokeLater(run);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int index = 1;
            this.m_Running = true;
            while (this.m_Running) {
                ++index;
                try {
                    Animation animation = this;
                    synchronized (animation) {
                        this.wait(this.m_Delay);
                    }
                    this.show(index);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (index != 4) continue;
                index = 0;
            }
            this.show(1);
        }

        public void stopAnimation() {
            this.m_Running = false;
        }
    }
}

