/*
 * Decompiled with CFR 0.152.
 */
package meka.gui.explorer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import meka.gui.core.ParameterPanel;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class ClassifyTabOptions
extends ParameterPanel {
    private static final long serialVersionUID = 20374810419572094L;
    protected JTextField m_TextSeed;
    protected JTextField m_TextSplitPercentage;
    protected JTextField m_TextFolds;
    protected JTextField m_TextTOP;
    protected JTextField m_TextVOP;
    protected JToggleButton m_ToggleRandomize;
    protected JButton m_ButtonFile;
    private JFileChooser fc = new JFileChooser();
    protected Instances m_FileTestset = null;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_TextSeed = new JTextField("1", 5);
        this.addParameter("Random seed", this.m_TextSeed);
        this.m_TextSplitPercentage = new JTextField("66.0", 5);
        this.addParameter("Split Percentage", this.m_TextSplitPercentage);
        this.m_TextFolds = new JTextField("10", 5);
        this.addParameter("CV folds", this.m_TextFolds);
        this.m_TextTOP = new JTextField("PCut1", 5);
        this.addParameter("Threshold", this.m_TextTOP);
        this.m_TextVOP = new JTextField("3", 5);
        this.addParameter("Verbosity", this.m_TextVOP);
        this.m_ToggleRandomize = new JToggleButton("Randomize", false);
        this.addParameter("Randomize?", this.m_ToggleRandomize);
        this.m_ButtonFile = new JButton("Open");
        this.m_ButtonFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClassifyTabOptions.this.fc.showOpenDialog(ClassifyTabOptions.this) == 0) {
                    try {
                        ClassifyTabOptions.this.m_FileTestset = ConverterUtils.DataSource.read((InputStream)new FileInputStream(ClassifyTabOptions.this.fc.getSelectedFile()));
                    }
                    catch (Exception exp) {
                        System.err.println("[Error] Failed to load file.");
                        exp.printStackTrace();
                    }
                }
            }
        });
        this.addParameter("Test File", this.m_ButtonFile);
    }

    public void setTestFile(Instances file) {
        this.m_FileTestset = file;
    }

    public Instances getTestFile() {
        return this.m_FileTestset;
    }

    public void setRandomize(boolean B) {
        this.m_ToggleRandomize.setSelected(B);
    }

    public boolean getRandomize() {
        return this.m_ToggleRandomize.isSelected();
    }

    public void setTOP(String value) {
        this.m_TextTOP.setText("" + value);
    }

    public String getTOP() {
        return this.m_TextTOP.getText();
    }

    public void setVOP(String value) {
        this.m_TextVOP.setText("" + value);
    }

    public String getVOP() {
        return this.m_TextVOP.getText();
    }

    public void setSeed(int value) {
        this.m_TextSeed.setText("" + value);
    }

    public int getSeed() {
        int result;
        try {
            result = Integer.parseInt(this.m_TextSeed.getText());
        }
        catch (Exception e) {
            System.err.println("Failed to parse seed value: " + this.m_TextSeed.getText());
            e.printStackTrace();
            result = 1;
        }
        return result;
    }

    public void setSplitPercentage(double value) {
        this.m_TextSplitPercentage.setText("" + value);
    }

    public double getSplitPercentage() {
        double result;
        try {
            result = Double.parseDouble(this.m_TextSplitPercentage.getText());
        }
        catch (Exception e) {
            System.err.println("Failed to parse percentage value: " + this.m_TextSplitPercentage.getText());
            e.printStackTrace();
            result = 1.0;
        }
        return result;
    }

    public void setFolds(int value) {
        this.m_TextFolds.setText("" + value);
    }

    public int getFolds() {
        int result;
        try {
            result = Integer.parseInt(this.m_TextFolds.getText());
        }
        catch (Exception e) {
            System.err.println("Failed to parse folds value: " + this.m_TextFolds.getText());
            e.printStackTrace();
            result = 1;
        }
        return result;
    }
}

