/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.eval.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYErrorRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.TSForecaster;
import weka.classifiers.timeseries.WekaForecaster;
import weka.classifiers.timeseries.core.TSLagMaker;
import weka.classifiers.timeseries.core.TSLagUser;
import weka.classifiers.timeseries.core.Utils;
import weka.classifiers.timeseries.eval.ErrorModule;
import weka.classifiers.timeseries.eval.graph.GraphDriver;
import weka.core.Instance;
import weka.core.Instances;

public class JFreeChartDriver
extends GraphDriver {
    protected JFreeChart getPredictedTargetsChart(TSForecaster forecaster, ErrorModule preds, List<String> targetNames, int stepNumber, int instanceNumOffset, Instances data) {
        String timeName;
        TSLagMaker lagMaker;
        TSLagMaker lagMaker2;
        if (forecaster instanceof TSLagUser && data != null && (lagMaker2 = ((TSLagUser)((Object)forecaster)).getTSLagMaker()).getAdjustForTrends() && !lagMaker2.isUsingAnArtificialTimeIndex()) {
            data = new Instances(data);
            data = Utils.replaceMissing(data, null, lagMaker2.getTimeStampField(), true, lagMaker2.getPeriodicity(), lagMaker2.getSkipEntries(), new Object[0]);
        }
        XYIntervalSeriesCollection xyDataset = new XYIntervalSeriesCollection();
        for (String target : targetNames) {
            XYIntervalSeries targetSeries = new XYIntervalSeries((Comparable)((Object)(target + "-actual")), false, false);
            xyDataset.addSeries(targetSeries);
            targetSeries = new XYIntervalSeries((Comparable)((Object)(target + "-predicted")), false, false);
            xyDataset.addSeries(targetSeries);
        }
        NumberAxis timeAxis = null;
        NumberAxis valueAxis = new NumberAxis("");
        valueAxis.setAutoRangeIncludesZero(false);
        int timeIndex = -1;
        boolean timeAxisIsDate = false;
        if (forecaster instanceof TSLagUser && data != null && !(lagMaker = ((TSLagUser)((Object)forecaster)).getTSLagMaker()).isUsingAnArtificialTimeIndex() && lagMaker.getAdjustForTrends() && data.attribute(timeName = lagMaker.getTimeStampField()).isDate()) {
            timeAxis = new DateAxis("");
            timeAxisIsDate = true;
            timeIndex = data.attribute(timeName).index();
        }
        if (timeAxis == null) {
            timeAxis = new NumberAxis("");
            timeAxis.setAutoRangeIncludesZero(false);
        }
        boolean hasConfidenceIntervals = false;
        for (int i = 0; i < targetNames.size(); ++i) {
            String targetName = targetNames.get(i);
            List<NumericPrediction> predsForI = preds.getPredictionsForTarget(targetName);
            int predIndex = xyDataset.indexOf((Comparable)((Object)(targetName + "-predicted")));
            int actualIndex = xyDataset.indexOf((Comparable)((Object)(targetName + "-actual")));
            XYIntervalSeries predSeries = xyDataset.getSeries(predIndex);
            XYIntervalSeries actualSeries = xyDataset.getSeries(actualIndex);
            for (int j = 0; j < predsForI.size(); ++j) {
                double yPredicted;
                double x = weka.core.Utils.missingValue();
                if (timeAxisIsDate) {
                    if (instanceNumOffset + j + stepNumber - 1 < data.numInstances()) {
                        x = data.instance(instanceNumOffset + j + stepNumber - 1).value(timeIndex);
                    }
                } else {
                    x = instanceNumOffset + j + stepNumber;
                }
                double yHigh = yPredicted = predsForI.get(j).predicted();
                double yLow = yPredicted;
                double[][] conf = predsForI.get(j).predictionIntervals();
                if (conf.length > 0) {
                    yLow = conf[0][0];
                    yHigh = conf[0][1];
                    hasConfidenceIntervals = true;
                }
                if (!weka.core.Utils.isMissingValue((double)x) && !weka.core.Utils.isMissingValue((double)yPredicted) && predSeries != null) {
                    predSeries.add(x, x, x, yPredicted, yLow, yHigh);
                }
                double yActual = predsForI.get(j).actual();
                if (weka.core.Utils.isMissingValue((double)x) || weka.core.Utils.isMissingValue((double)yActual) || actualSeries == null) continue;
                actualSeries.add(x, x, x, yActual, yActual, yActual);
            }
        }
        String title = "" + stepNumber + " step-ahead predictions for: ";
        for (String s : targetNames) {
            title = title + s + ",";
        }
        title = title.substring(0, title.lastIndexOf(","));
        if (forecaster instanceof WekaForecaster && hasConfidenceIntervals) {
            double confPerc = ((WekaForecaster)forecaster).getConfidenceLevel() * 100.0;
            title = title + " [" + weka.core.Utils.doubleToString((double)confPerc, (int)0) + "% conf. intervals]";
        }
        XYErrorRenderer renderer = new XYErrorRenderer();
        renderer.setBaseLinesVisible(true);
        renderer.setDrawXError(false);
        renderer.setDrawYError(true);
        XYPlot plot = new XYPlot((XYDataset)xyDataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.setBackgroundPaint((Paint)Color.white);
        TextTitle chartTitle = chart.getTitle();
        String fontName = chartTitle.getFont().getFontName();
        Font newFont = new Font(fontName, 0, 12);
        chartTitle.setFont(newFont);
        return chart;
    }

    @Override
    public void saveChartToFile(JPanel chart, String filename, int width, int height) throws Exception {
        if (!(chart instanceof ChartPanel)) {
            throw new Exception("Chart is not a JFreeChart!");
        }
        if (filename.toLowerCase().lastIndexOf(".png") < 0) {
            filename = filename + ".png";
        }
        ChartUtilities.saveChartAsPNG((File)new File(filename), (JFreeChart)((ChartPanel)chart).getChart(), (int)width, (int)height);
    }

    @Override
    public Image getImageFromChart(JPanel chart, int width, int height) throws Exception {
        if (!(chart instanceof ChartPanel)) {
            throw new Exception("Chart is not a JFreeChart!");
        }
        BufferedImage result = ((ChartPanel)chart).getChart().createBufferedImage(width, height);
        return result;
    }

    @Override
    public JPanel getGraphPanelTargets(TSForecaster forecaster, ErrorModule preds, List<String> targetNames, int stepNumber, int instanceNumOffset, Instances data) throws Exception {
        JFreeChart chart = this.getPredictedTargetsChart(forecaster, preds, targetNames, stepNumber, instanceNumOffset, data);
        ChartPanel result = new ChartPanel(chart, false, true, true, true, false);
        return result;
    }

    protected JFreeChart getPredictedStepsChart(TSForecaster forecaster, List<ErrorModule> preds, String targetName, List<Integer> stepsToPlot, int instanceNumOffset, Instances data) {
        String timeName;
        TSLagMaker lagMaker;
        TSLagMaker lagMaker2;
        if (forecaster instanceof TSLagUser && data != null && (lagMaker2 = ((TSLagUser)((Object)forecaster)).getTSLagMaker()).getAdjustForTrends() && !lagMaker2.isUsingAnArtificialTimeIndex()) {
            data = new Instances(data);
            data = Utils.replaceMissing(data, null, lagMaker2.getTimeStampField(), true, lagMaker2.getPeriodicity(), lagMaker2.getSkipEntries(), new Object[0]);
        }
        XYIntervalSeriesCollection xyDataset = new XYIntervalSeriesCollection();
        XYIntervalSeries targetSeries = new XYIntervalSeries((Comparable)((Object)targetName), false, false);
        xyDataset.addSeries(targetSeries);
        for (int z = 0; z < stepsToPlot.size(); ++z) {
            int i = stepsToPlot.get(z);
            if (--i < 0 || i >= preds.size()) continue;
            String step = "-steps";
            if (i == 0) {
                step = "-step";
            }
            targetSeries = new XYIntervalSeries((Comparable)((Object)(targetName + "_" + (i + 1) + step + "-ahead")), false, false);
            xyDataset.addSeries(targetSeries);
        }
        NumberAxis timeAxis = null;
        NumberAxis valueAxis = new NumberAxis("");
        valueAxis.setAutoRangeIncludesZero(false);
        int timeIndex = -1;
        boolean timeAxisIsDate = false;
        if (forecaster instanceof TSLagUser && data != null && !(lagMaker = ((TSLagUser)((Object)forecaster)).getTSLagMaker()).isUsingAnArtificialTimeIndex() && lagMaker.getAdjustForTrends() && data.attribute(timeName = lagMaker.getTimeStampField()).isDate()) {
            timeAxis = new DateAxis("");
            timeAxisIsDate = true;
            timeIndex = data.attribute(timeName).index();
        }
        if (timeAxis == null) {
            timeAxis = new NumberAxis("");
            timeAxis.setAutoRangeIncludesZero(false);
        }
        boolean doneActual = false;
        boolean hasConfidenceIntervals = false;
        for (int z = 0; z < stepsToPlot.size(); ++z) {
            int i = stepsToPlot.get(z);
            if (--i < 0 || i >= preds.size()) continue;
            ErrorModule predsForStepI = preds.get(i);
            List<NumericPrediction> predsForTargetAtI = predsForStepI.getPredictionsForTarget(targetName);
            String step = "-steps";
            if (i == 0) {
                step = "-step";
            }
            int predIndex = xyDataset.indexOf((Comparable)((Object)(targetName + "_" + (i + 1) + step + "-ahead")));
            XYIntervalSeries predSeries = xyDataset.getSeries(predIndex);
            XYIntervalSeries actualSeries = null;
            if (!doneActual) {
                int actualIndex = xyDataset.indexOf((Comparable)((Object)targetName));
                actualSeries = xyDataset.getSeries(actualIndex);
            }
            for (int j = 0; j < predsForTargetAtI.size(); ++j) {
                double yPredicted;
                double x = weka.core.Utils.missingValue();
                if (timeAxisIsDate) {
                    if (instanceNumOffset + j + i < data.numInstances()) {
                        x = data.instance(instanceNumOffset + j + i).value(timeIndex);
                    }
                } else {
                    x = instanceNumOffset + j + i;
                }
                double yHigh = yPredicted = predsForTargetAtI.get(j).predicted();
                double yLow = yPredicted;
                double[][] conf = predsForTargetAtI.get(j).predictionIntervals();
                if (conf.length > 0) {
                    yLow = conf[0][0];
                    yHigh = conf[0][1];
                    hasConfidenceIntervals = true;
                }
                if (!weka.core.Utils.isMissingValue((double)x) && !weka.core.Utils.isMissingValue((double)yPredicted) && predSeries != null) {
                    predSeries.add(x, x, x, yPredicted, yLow, yHigh);
                }
                if (doneActual || actualSeries == null) continue;
                double yActual = predsForTargetAtI.get(j).actual();
                if (weka.core.Utils.isMissingValue((double)x) || weka.core.Utils.isMissingValue((double)yActual)) continue;
                actualSeries.add(x, x, x, yActual, yActual, yActual);
            }
            if (actualSeries == null) continue;
            doneActual = true;
        }
        String title = "";
        for (int i : stepsToPlot) {
            title = title + i + ",";
        }
        title = title.substring(0, title.lastIndexOf(","));
        title = title + " step-ahead predictions for " + targetName;
        if (forecaster instanceof WekaForecaster && hasConfidenceIntervals) {
            double confPerc = ((WekaForecaster)forecaster).getConfidenceLevel() * 100.0;
            title = title + " [" + weka.core.Utils.doubleToString((double)confPerc, (int)0) + "% conf. intervals]";
        }
        XYErrorRenderer renderer = new XYErrorRenderer();
        renderer.setBaseLinesVisible(true);
        XYPlot plot = new XYPlot((XYDataset)xyDataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.setBackgroundPaint((Paint)Color.white);
        TextTitle chartTitle = chart.getTitle();
        String fontName = chartTitle.getFont().getFontName();
        Font newFont = new Font(fontName, 0, 12);
        chartTitle.setFont(newFont);
        return chart;
    }

    @Override
    public JPanel getGraphPanelSteps(TSForecaster forecaster, List<ErrorModule> preds, String targetName, List<Integer> stepsToPlot, int instanceNumOffset, Instances data) throws Exception {
        JFreeChart chart = this.getPredictedStepsChart(forecaster, preds, targetName, stepsToPlot, instanceNumOffset, data);
        ChartPanel result = new ChartPanel(chart, false, true, true, true, false);
        return result;
    }

    protected JFreeChart getFutureForecastChart(TSForecaster forecaster, List<List<NumericPrediction>> preds, List<String> targetNames, Instances history) {
        double y;
        XYIntervalSeries targetSeries;
        TSLagMaker lagMaker;
        if (forecaster instanceof TSLagUser && history != null && (lagMaker = ((TSLagUser)((Object)forecaster)).getTSLagMaker()).getAdjustForTrends() && !lagMaker.isUsingAnArtificialTimeIndex()) {
            history = new Instances(history);
            history = Utils.replaceMissing(history, null, lagMaker.getTimeStampField(), true, lagMaker.getPeriodicity(), lagMaker.getSkipEntries(), new Object[0]);
        }
        XYIntervalSeriesCollection xyDataset = new XYIntervalSeriesCollection();
        if (history != null) {
            for (String targetName : targetNames) {
                targetSeries = new XYIntervalSeries((Comparable)((Object)targetName), false, false);
                xyDataset.addSeries(targetSeries);
            }
        }
        for (String targetName : targetNames) {
            targetSeries = new XYIntervalSeries((Comparable)((Object)(targetName + "-predicted")), false, false);
            xyDataset.addSeries(targetSeries);
        }
        NumberAxis timeAxis = null;
        NumberAxis valueAxis = new NumberAxis("");
        valueAxis.setAutoRangeIncludesZero(false);
        int timeIndex = -1;
        boolean timeAxisIsDate = false;
        double artificialTimeStart = 0.0;
        double lastRealTimeValue = weka.core.Utils.missingValue();
        if (forecaster instanceof TSLagUser && history != null) {
            TSLagMaker lagMaker2 = ((TSLagUser)((Object)forecaster)).getTSLagMaker();
            if (!lagMaker2.isUsingAnArtificialTimeIndex() && lagMaker2.getAdjustForTrends()) {
                String timeName = lagMaker2.getTimeStampField();
                if (history.attribute(timeName).isDate()) {
                    timeAxis = new DateAxis("");
                    timeAxisIsDate = true;
                    timeIndex = history.attribute(timeName).index();
                }
            } else {
                try {
                    artificialTimeStart = history != null ? 1.0 : lagMaker2.getArtificialTimeStartValue() + 1.0;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (timeAxis == null) {
            timeAxis = new NumberAxis("");
            timeAxis.setAutoRangeIncludesZero(false);
        }
        boolean hasConfidenceIntervals = false;
        if (history != null) {
            for (int i = 0; i < history.numInstances(); ++i) {
                Instance current = history.instance(i);
                for (String targetName : targetNames) {
                    int dataIndex = history.attribute(targetName.trim()).index();
                    if (dataIndex < 0) continue;
                    XYIntervalSeries actualSeries = null;
                    int actualIndex = xyDataset.indexOf((Comparable)((Object)targetName));
                    actualSeries = xyDataset.getSeries(actualIndex);
                    double x = weka.core.Utils.missingValue();
                    if (timeAxisIsDate) {
                        x = current.value(timeIndex);
                        if (!weka.core.Utils.isMissingValue((double)x)) {
                            lastRealTimeValue = x;
                        }
                    } else {
                        x = artificialTimeStart;
                    }
                    y = weka.core.Utils.missingValue();
                    y = current.value(dataIndex);
                    if (weka.core.Utils.isMissingValue((double)x) || weka.core.Utils.isMissingValue((double)y) || actualSeries == null) continue;
                    actualSeries.add(x, x, x, y, y, y);
                }
                if (timeAxisIsDate) continue;
                artificialTimeStart += 1.0;
            }
        }
        List<String> forecasterTargets = AbstractForecaster.stringToList(forecaster.getFieldsToForecast());
        for (int j = 0; j < preds.size(); ++j) {
            List<NumericPrediction> predsForStepJ = preds.get(j);
            if (timeAxisIsDate) {
                lastRealTimeValue = ((TSLagUser)((Object)forecaster)).getTSLagMaker().advanceSuppliedTimeValue(lastRealTimeValue);
            }
            for (String targetName : targetNames) {
                int predIndex = forecasterTargets.indexOf(targetName.trim());
                if (predIndex < 0) continue;
                NumericPrediction predsForTargetAtStepJ = predsForStepJ.get(predIndex);
                XYIntervalSeries predSeries = null;
                int datasetIndex = xyDataset.indexOf((Comparable)((Object)(targetName + "-predicted")));
                predSeries = xyDataset.getSeries(datasetIndex);
                if (predSeries == null) continue;
                y = predsForTargetAtStepJ.predicted();
                double x = weka.core.Utils.missingValue();
                double yHigh = y;
                double yLow = y;
                double[][] conf = predsForTargetAtStepJ.predictionIntervals();
                if (conf.length > 0) {
                    yLow = conf[0][0];
                    yHigh = conf[0][1];
                    hasConfidenceIntervals = true;
                }
                if (weka.core.Utils.isMissingValue((double)(x = !timeAxisIsDate ? artificialTimeStart : lastRealTimeValue)) || weka.core.Utils.isMissingValue((double)y)) continue;
                predSeries.add(x, x, x, y, yLow, yHigh);
            }
            if (timeAxisIsDate) continue;
            artificialTimeStart += 1.0;
        }
        String title = "Future forecast for: ";
        for (String s : targetNames) {
            title = title + s + ",";
        }
        title = title.substring(0, title.lastIndexOf(","));
        if (forecaster instanceof WekaForecaster && hasConfidenceIntervals) {
            double confPerc = ((WekaForecaster)forecaster).getConfidenceLevel() * 100.0;
            title = title + " [" + weka.core.Utils.doubleToString((double)confPerc, (int)0) + "% conf. intervals]";
        }
        XYErrorRenderer renderer = new XYErrorRenderer();
        XYPlot plot = new XYPlot((XYDataset)xyDataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        if (history != null) {
            for (String targetName : targetNames) {
                XYIntervalSeries predSeries = null;
                int predIndex = xyDataset.indexOf((Comparable)((Object)(targetName + "-predicted")));
                predSeries = xyDataset.getSeries(predIndex);
                XYIntervalSeries actualSeries = null;
                int actualIndex = xyDataset.indexOf((Comparable)((Object)targetName));
                actualSeries = xyDataset.getSeries(actualIndex);
                if (actualSeries == null || predSeries == null) continue;
                Paint actualPaint = renderer.lookupSeriesPaint(actualIndex);
                renderer.setSeriesPaint(predIndex, actualPaint);
                BasicStroke dashed = new BasicStroke(1.5f, 0, 0, 10.0f, new float[]{5.0f}, 0.0f);
                renderer.setSeriesStroke(predIndex, (Stroke)dashed);
            }
        }
        renderer.setBaseLinesVisible(true);
        renderer.setDrawXError(false);
        renderer.setDrawYError(true);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.setBackgroundPaint((Paint)Color.white);
        TextTitle chartTitle = chart.getTitle();
        String fontName = chartTitle.getFont().getFontName();
        Font newFont = new Font(fontName, 0, 12);
        chartTitle.setFont(newFont);
        return chart;
    }

    @Override
    public JPanel getPanelFutureForecast(TSForecaster forecaster, List<List<NumericPrediction>> preds, List<String> targetNames, Instances history) throws Exception {
        JFreeChart chart = this.getFutureForecastChart(forecaster, preds, targetNames, history);
        ChartPanel result = new ChartPanel(chart, false, true, true, true, false);
        return result;
    }
}

