/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3;

import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadView;
import boofcv.alg.sfm.overhead.OverheadView;
import boofcv.alg.sfm.overhead.SelectOverheadParameters;
import boofcv.factory.sfm.FactorySfmMisc;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DenseMatrix64F;

public class VisOdomMonoOverheadMotion2D<T extends ImageBase> {
    private CreateSyntheticOverheadView<T> createOverhead;
    private ImageMotion2D<T, Se2_F64> motion2D;
    private OverheadView<T> overhead;
    private SelectOverheadParameters selectOverhead;
    private Se3_F64 planeToCamera;
    private Se2_F64 worldToCurr2D = new Se2_F64();
    private Se3_F64 worldToCurrCam3D = new Se3_F64();
    private Se3_F64 worldToCurr3D = new Se3_F64();
    private Se2_F64 temp = new Se2_F64();
    private Se2_F64 origToMap = new Se2_F64();
    private Se2_F64 mapToOrigin = new Se2_F64();

    public VisOdomMonoOverheadMotion2D(double cellSize, double maxCellsPerPixel, double mapHeightFraction, ImageMotion2D<T, Se2_F64> motion2D, ImageType<T> imageType) {
        this.selectOverhead = new SelectOverheadParameters(cellSize, maxCellsPerPixel, mapHeightFraction);
        this.motion2D = motion2D;
        this.createOverhead = FactorySfmMisc.createOverhead(imageType);
        this.overhead = new OverheadView<ImageBase>(imageType.createImage(1, 1), 0.0, 0.0, cellSize);
    }

    public void configureCamera(IntrinsicParameters intrinsic, Se3_F64 planeToCamera) {
        this.planeToCamera = planeToCamera;
        if (!this.selectOverhead.process(intrinsic, planeToCamera)) {
            throw new IllegalArgumentException("Can't find a reasonable overhead map.  Can the camera view the plane?");
        }
        this.overhead.centerX = this.selectOverhead.getCenterX();
        this.overhead.centerY = this.selectOverhead.getCenterY();
        this.createOverhead.configure(intrinsic, planeToCamera, this.overhead.centerX, this.overhead.centerY, this.overhead.cellSize, this.selectOverhead.getOverheadWidth(), this.selectOverhead.getOverheadHeight());
        this.origToMap.set(this.overhead.centerX, this.overhead.centerY, 0.0);
        this.mapToOrigin.set(-this.overhead.centerX, -this.overhead.centerY, 0.0);
        this.overhead.image.reshape(this.selectOverhead.getOverheadWidth(), this.selectOverhead.getOverheadHeight());
        GImageMiscOps.fill(this.overhead.image, (double)0.0);
    }

    public void reset() {
        this.motion2D.reset();
    }

    public boolean process(T image) {
        this.createOverhead.process(image, this.overhead.image);
        if (!this.motion2D.process(this.overhead.image)) {
            return false;
        }
        this.worldToCurr2D.set(this.motion2D.getFirstToCurrent());
        this.worldToCurr2D.T.x *= this.overhead.cellSize;
        this.worldToCurr2D.T.y *= this.overhead.cellSize;
        this.origToMap.concat(this.worldToCurr2D, this.temp);
        this.temp.concat(this.mapToOrigin, this.worldToCurr2D);
        return true;
    }

    public Se2_F64 getWorldToCurr2D() {
        return this.worldToCurr2D;
    }

    public Se3_F64 getWorldToCurr3D() {
        this.worldToCurr3D.getT().set(-this.worldToCurr2D.T.y, 0.0, this.worldToCurr2D.T.x);
        DenseMatrix64F R = this.worldToCurr3D.getR();
        R.unsafe_set(0, 0, this.worldToCurr2D.c);
        R.unsafe_set(0, 2, -this.worldToCurr2D.s);
        R.unsafe_set(1, 1, 1.0);
        R.unsafe_set(2, 0, this.worldToCurr2D.s);
        R.unsafe_set(2, 2, this.worldToCurr2D.c);
        this.worldToCurr3D.concat(this.planeToCamera, this.worldToCurrCam3D);
        return this.worldToCurrCam3D;
    }

    public OverheadView<T> getOverhead() {
        return this.overhead;
    }

    public ImageMotion2D<T, Se2_F64> getMotion2D() {
        return this.motion2D;
    }
}

