/*
 * Decompiled with CFR 0.152.
 */
package adams.ml;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.ml.BaseData;
import adams.ml.DataRow;
import adams.ml.Dataset;
import java.io.BufferedReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

@Deprecated
public class CSVDataset
extends Dataset {
    private static final long serialVersionUID = 2656050894378581346L;
    protected Hashtable<Integer, String> m_columnToName = new Hashtable();
    protected Hashtable<String, Integer> m_nameToColumn = new Hashtable();
    protected Hashtable<Integer, Vector<Integer>> m_index = new Hashtable();

    protected boolean hasColumn(String col) {
        return this.m_nameToColumn.get(col) != null;
    }

    protected void setIndex(String columnname) {
        this.m_index.clear();
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            BaseData cell = dr.get(columnname);
            if (cell == null || !cell.isNumeric()) continue;
            try {
                Integer i = (Integer)cell.getData();
                Vector<Integer> rows = this.m_index.get(i);
                if (rows == null) {
                    rows = new Vector();
                    this.m_index.put(i, rows);
                }
                rows.add(row);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object[] toArray(String columnname) {
        Object[] oarr = new Object[this.count()];
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            BaseData cell = dr.get(columnname);
            oarr[row] = cell != null ? cell.getData() : null;
        }
        return oarr;
    }

    protected Vector<Integer> getFromIndex(Integer i) {
        Vector<Integer> ret = this.m_index.get(i);
        if (ret == null) {
            ret = new Vector();
        }
        return ret;
    }

    protected void addError(int row, String col) {
        Vector<String> err = (Vector<String>)this.m_errors.get(row);
        if (err == null) {
            err = new Vector<String>();
        }
        err.add(col);
        this.m_errors.put(row, err);
    }

    protected void setColumn(int cn, String name) {
        this.m_columnToName.put(cn, name);
        this.m_nameToColumn.put(name, cn);
    }

    protected boolean columnPresent(String name) {
        return this.m_nameToColumn.get(name) != null;
    }

    protected Integer getColumn(String name) {
        return this.m_nameToColumn.get(name);
    }

    protected void renameColumn(String oldn, String newn) {
        Integer col = this.getColumn(oldn);
        if (col != null) {
            this.setColumn(col, newn);
            this.m_nameToColumn.remove(oldn);
        }
        for (DataRow dr : this.m_rows) {
            dr.renameColumn(oldn, newn);
        }
    }

    protected String unquote(String s) {
        String result = Utils.unquote((String)s);
        result = Utils.unDoubleQuote((String)result);
        return result;
    }

    protected String[] breakUp(String line) {
        Vector<String> result = new Vector<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        char escapeChr = '\u0000';
        for (int i = 0; i < line.length(); ++i) {
            char chr = line.charAt(i);
            if (chr == ',' || chr == '\t') {
                if (escaped) {
                    current.append(chr);
                    continue;
                }
                result.add(this.unquote(current.toString()));
                current = new StringBuilder();
                continue;
            }
            if (chr == '\"') {
                if (i > 0 && line.charAt(i - 1) == '\\') {
                    current.append(chr);
                    continue;
                }
                if (escaped && escapeChr == chr) {
                    escaped = false;
                    current.append(chr);
                    continue;
                }
                escaped = true;
                escapeChr = chr;
                current.append(chr);
                continue;
            }
            current.append(chr);
        }
        result.add(this.unquote(current.toString()));
        return result.toArray(new String[result.size()]);
    }

    protected String readLine(BufferedReader r) {
        StringBuffer result = new StringBuffer();
        boolean reading = true;
        try {
            int count = 0;
            while (reading) {
                String res = r.readLine();
                if (res == null) {
                    return null;
                }
                result.append(res);
                reading = false;
                for (int i = res.length() - 1; i >= 0; --i) {
                    if (res.charAt(i) != '\"') continue;
                    ++count;
                }
                if (!(count & true)) continue;
                reading = true;
            }
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result.toString();
    }

    public void requireString(String columnname, String value) {
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            BaseData cell = dr.get(columnname);
            if (cell == null || value.equals(cell.toString())) continue;
            this.addError(row, columnname);
        }
    }

    public void requireString(String columnname, String[] values) {
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            BaseData cell = dr.get(columnname);
            if (cell == null) continue;
            boolean found = false;
            for (String s : values) {
                if (!s.equals(cell.toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.addError(row, columnname);
        }
    }

    public void requireInteger(String[] columnnames) {
        for (String s : columnnames) {
            this.requireInteger(s);
        }
    }

    public void requireNotEmpty(String[] columnnames) {
        for (String s : columnnames) {
            this.requireNotEmpty(s);
        }
    }

    public void requireInteger(String columnname, int value) {
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            BaseData cell = dr.get(columnname);
            if (cell == null) continue;
            try {
                Integer pi = Integer.parseInt(cell.toString());
                if (pi == value) {
                    dr.set(columnname, pi);
                    continue;
                }
                this.addError(row, columnname);
                continue;
            }
            catch (Exception e) {
                this.addError(row, columnname);
            }
        }
    }

    public void requireInteger(String columnname) {
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            BaseData cell = dr.get(columnname);
            if (cell == null) continue;
            try {
                Integer pi = Integer.parseInt(cell.toString());
                dr.set(columnname, pi);
                continue;
            }
            catch (Exception e) {
                this.addError(row, columnname);
            }
        }
    }

    public void requireDouble(String columnname) {
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            BaseData cell = dr.get(columnname);
            if (cell == null) continue;
            try {
                Double pi = Double.parseDouble(cell.toString());
                dr.set(columnname, pi);
                continue;
            }
            catch (Exception e) {
                this.addError(row, columnname);
            }
        }
    }

    public void requireNotEmpty(String columnname) {
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            BaseData cell = dr.get(columnname);
            if (cell != null && !cell.toString().equals("")) continue;
            this.addError(row, columnname);
        }
    }

    public void requireFloat(String columnname) {
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            BaseData cell = dr.get(columnname);
            if (cell == null) continue;
            try {
                Float pf = Float.valueOf(Float.parseFloat(cell.toString()));
                dr.set(columnname, pf);
                continue;
            }
            catch (Exception e) {
                this.addError(row, columnname);
            }
        }
    }

    public CSVDataset dateMinMax(String columnname, BaseData.Date min, BaseData.Date max) {
        CSVDataset ret = new CSVDataset();
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr;
            BaseData cell;
            if (this.m_errors.get(row) != null || (cell = (dr = this.get(row)).get(columnname)) == null || !cell.isDate() || !((BaseData.Date)cell.getData()).between(min, max)) continue;
            ret.add(dr.copy());
        }
        return ret;
    }

    public CSVDataset getWithIntValue(String columnname, Integer val) {
        CSVDataset ret = new CSVDataset();
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr;
            BaseData cell;
            if (this.m_errors.get(row) != null || (cell = (dr = this.get(row)).get(columnname)) == null || !cell.isNumeric() || !cell.isNumeric() || !val.equals(cell.getData())) continue;
            ret.add(dr.copy());
        }
        return ret;
    }

    @Override
    public CSVDataset getWithStringValue(String columnname, String val) {
        CSVDataset ret = new CSVDataset();
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr;
            BaseData cell;
            if (this.m_errors.get(row) != null || (cell = (dr = this.get(row)).get(columnname)) == null || !val.equals(cell.getData().toString())) continue;
            ret.add(dr.copy());
        }
        return ret;
    }

    public void requireDate(String columnname, String ps) {
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            BaseData cell = dr.get(columnname);
            if (cell == null) continue;
            SimpleDateFormat formatter = new SimpleDateFormat(ps);
            formatter.setLenient(true);
            try {
                Date dateStr = formatter.parse(cell.toString());
                Calendar cal = Calendar.getInstance();
                cal.setTime(dateStr);
                int month = cal.get(2);
                BaseData.Date date = new BaseData.Date(cal.get(5), cal.get(2) + 1, cal.get(1));
                dr.set(columnname, date);
                continue;
            }
            catch (ParseException e) {
                this.addError(row, columnname);
                System.err.println("Error line:" + row + " " + cell.toString());
            }
        }
    }

    public void requireTime(String columnname, String ps) {
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            BaseData cell = dr.get(columnname);
            if (cell == null) continue;
            SimpleDateFormat formatter = new SimpleDateFormat(ps);
            try {
                Date dateStr = formatter.parse(ps);
                BaseData.Time date = new BaseData.Time(dateStr.getHours(), dateStr.getMinutes(), dateStr.getSeconds(), 0);
                dr.set(columnname, date);
                continue;
            }
            catch (ParseException e) {
                System.err.println("Error line:" + row + " ");
                dr.set(columnname, null);
            }
        }
    }

    public String showErrors() {
        StringBuffer sb = new StringBuffer();
        for (int row = 0; row < this.count(); ++row) {
            Vector errs = (Vector)this.m_errors.get(row);
            if (errs == null) continue;
            DataRow dr = this.get(row);
            int i = 0;
            sb.append(row + "  ");
            for (String s : this.m_nameToColumn.keySet()) {
                sb.append(s);
                for (String c : errs) {
                    if (!c.equals(s)) continue;
                    sb.append("*");
                }
                sb.append(":");
                BaseData bd = dr.get(s);
                if (bd != null) {
                    if (bd.isString()) {
                        sb.append("\"");
                        sb.append(dr.getObject(s));
                        sb.append("\"");
                    } else {
                        sb.append(dr.getObject(s));
                    }
                }
                if (i != this.m_nameToColumn.keySet().size() - 1) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toCSV(String[] columns, boolean showErrors) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < columns.length; ++i) {
            sb.append(columns[i]);
            if (i == columns.length - 1) continue;
            sb.append(",");
        }
        sb.append("\n");
        for (int row = 0; row < this.count(); ++row) {
            if (this.m_errors.get(row) != null) continue;
            DataRow dr = this.get(row);
            for (int i = 0; i < columns.length; ++i) {
                BaseData bd = dr.get(columns[i]);
                if (bd != null) {
                    if (bd.isString()) {
                        sb.append("\"");
                        sb.append(dr.getObject(columns[i]));
                        sb.append("\"");
                    } else {
                        sb.append(dr.getObject(columns[i]));
                    }
                }
                if (i == columns.length - 1) continue;
                sb.append(",");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean loadCSV(Reader r) {
        boolean result = true;
        Vector<Integer> ignore = new Vector<Integer>();
        this.m_columnToName = new Hashtable();
        this.m_nameToColumn = new Hashtable();
        this.m_errors = new Hashtable();
        BufferedReader reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        try {
            String line;
            String[] headerCells = null;
            while ((line = this.readLine(reader)) != null) {
                if (line.trim().length() == 0) continue;
                String[] cells = this.breakUp(line);
                if (headerCells == null) {
                    headerCells = cells;
                    for (int i = 0; i < headerCells.length; ++i) {
                        if (this.columnPresent(headerCells[i])) {
                            System.err.println("Warning ignoring duplicate column:" + i);
                            ignore.add(i);
                            continue;
                        }
                        if (headerCells[i].equals("")) {
                            System.err.println("Warning empty column header:" + i);
                            continue;
                        }
                        this.setColumn(i, headerCells[i]);
                    }
                    continue;
                }
                DataRow dr = new DataRow();
                this.add(dr);
                for (int i = 0; i < cells.length; ++i) {
                    Iterator iterator = ignore.iterator();
                    while (iterator.hasNext()) {
                        int ig = (Integer)iterator.next();
                        if (i != ig) continue;
                    }
                    String nm = this.m_columnToName.get(i);
                    if (nm == null) {
                        nm = "Column" + i;
                    }
                    if (cells[i] == null || cells[i].equals("")) continue;
                    dr.set(nm, cells[i]);
                }
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public void save(String string, String[] summariseHeader) {
        FileUtils.writeToFile((String)string, (Object)this.toCSV(summariseHeader, false));
    }
}

