/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractCopyCallableActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class CopyCallableSink
extends AbstractCopyCallableActor
implements InputConsumer {
    private static final long serialVersionUID = 4736661460553985100L;
    public static final String BACKUP_CURRENT = "current";
    protected transient Token m_CurrentInput;

    public String globalInfo() {
        return "Copies a callable sink to consume the tokens.";
    }

    @Override
    protected AbstractActor findCallableActor() {
        AbstractActor result = super.findCallableActor();
        if (result != null && !ActorUtils.isSink((Actor)result)) {
            this.getLogger().severe("Callable actor '" + result.getFullName() + "' is not a sink" + (this.m_CallableActor == null ? "!" : this.m_CallableActor.getClass().getName()));
            result = null;
        }
        return result;
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_CURRENT, this.m_CurrentInput);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENT)) {
            this.m_CurrentInput = (Token)state.get(BACKUP_CURRENT);
            state.remove(BACKUP_CURRENT);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_CurrentInput = null;
    }

    public Class[] accepts() {
        if (this.m_CallableActor != null) {
            return ((InputConsumer)this.m_CallableActor).accepts();
        }
        return new Class[]{Unknown.class};
    }

    public void input(Token token) {
        this.m_CurrentInput = token;
    }

    @Override
    protected String executeCallableActor() {
        ((InputConsumer)this.m_CallableActor).input(this.m_CurrentInput);
        String result = this.m_CallableActor.execute();
        return result;
    }
}

