/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class LogReader
extends FilterReader {
    Writer log;

    public LogReader(Reader reader, Writer writer) {
        super(reader);
        this.setLog(writer);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.getLog() != null) {
            this.getLog().close();
        }
    }

    public Writer getLog() {
        return this.log;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n > -1 && this.log != null) {
            this.log.write(n);
        }
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = super.read(cArray, n, n2);
        if (n3 > -1 && this.log != null) {
            this.log.write(cArray, n, n3);
        }
        return n3;
    }

    public void setLog(Writer writer) {
        this.log = writer;
    }
}

