/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tree;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.tree.CommonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class CommonNodeFactory<T extends CommonNode> {
    private Map<Class<?>, CommonNodeFactory<?>> children;
    private final Map<Object, CommonNode> nodeMap = new WeakHashMap<Object, CommonNode>();
    private final Attribute attrNodeMap = new Attribute("nodeMap");

    protected CommonNodeFactory() {
    }

    public abstract T createNode(CommonNode var1, Object var2);

    public synchronized CommonNodeFactory<?> lookupFactory(Object object) {
        if (this.children == null) {
            return this;
        }
        Class<?> clazz = object.getClass();
        while (clazz != null) {
            CommonNodeFactory<?> commonNodeFactory = this.children.get(clazz);
            if (commonNodeFactory != null) {
                return commonNodeFactory;
            }
            clazz = clazz.getSuperclass();
        }
        return this;
    }

    public synchronized CommonNode lookupNode(CommonNode commonNode, Object object) {
        if (commonNode == null) {
            return this.nodeMap.get(object);
        }
        Map map = (Map)commonNode.getAttribute(this.attrNodeMap);
        if (map == null) {
            return null;
        }
        return (CommonNode)map.get(object);
    }

    public synchronized void registerFactory(Class<?> clazz, CommonNodeFactory<?> commonNodeFactory) {
        if (this.children == null) {
            this.children = new HashMap();
        }
        this.children.put(clazz, commonNodeFactory);
    }

    public synchronized void registerNode(CommonNode commonNode, CommonNode commonNode2) {
        if (commonNode == null) {
            this.nodeMap.put(commonNode2.getObject(), commonNode2);
        } else {
            WeakHashMap weakHashMap = (WeakHashMap)commonNode.getAttribute(this.attrNodeMap);
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap();
                commonNode.setAttribute(this.attrNodeMap, weakHashMap);
            }
            weakHashMap.put(commonNode2.getObject(), commonNode2);
        }
    }
}

