/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.struct.feature.ScalePoint;
import georegression.struct.point.Point2D_I32;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;

public class VisualizeFeatures {
    public static void drawPoints(Graphics2D g2, Color color, List<Point2D_I32> points, int radius) {
        g2.setStroke(new BasicStroke(2.0f));
        int ro = radius + 1;
        int wo = ro * 2 + 1;
        int w = radius * 2 + 1;
        for (Point2D_I32 p : points) {
            g2.setColor(color);
            g2.fillOval(p.x - radius, p.y - radius, w, w);
            g2.setColor(Color.BLACK);
            g2.drawOval(p.x - ro, p.y - ro, wo, wo);
        }
    }

    public static void drawPoint(Graphics2D g2, int x, int y, Color color) {
        VisualizeFeatures.drawPoint(g2, x, y, 5, color);
    }

    public static void drawPoint(Graphics2D g2, int x, int y, int r, Color color) {
        VisualizeFeatures.drawPoint(g2, x, y, r, color, true);
    }

    public static void drawPoint(Graphics2D g2, int x, int y, int r, Color color, boolean hasBorder) {
        int w = r * 2 + 1;
        if (hasBorder) {
            int r2 = r + 2;
            int w2 = r2 * 2 + 1;
            g2.setColor(Color.BLACK);
            g2.fillOval(x - r2, y - r2, w2, w2);
        }
        g2.setColor(color);
        g2.fillOval(x - r, y - r, w, w);
    }

    public static void drawCross(Graphics2D g2, int x, int y, int r) {
        g2.drawLine(x - r, y, x + r, y);
        g2.drawLine(x, y - r, x, y + r);
    }

    public static void drawScalePoints(Graphics2D g2, List<ScalePoint> points, double radius) {
        g2.setColor(Color.RED);
        g2.setStroke(new BasicStroke(3.0f));
        for (ScalePoint p : points) {
            int r = (int)(radius * p.scale);
            int w = r * 2 + 1;
            g2.drawOval((int)p.x - r, (int)p.y - r, w, w);
        }
    }
}

