/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.struct.image.ImageUInt8;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImageBinaryPanel
extends JPanel {
    protected BufferedImage img;
    protected ImageUInt8 binaryImage;

    public ImageBinaryPanel(ImageUInt8 binaryImage) {
        this.binaryImage = binaryImage;
        this.img = new BufferedImage(binaryImage.getWidth(), binaryImage.getHeight(), 10);
        VisualizeBinaryData.renderBinary(binaryImage, this.img);
        this.setPreferredSize(new Dimension(binaryImage.getWidth(), binaryImage.getHeight()));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    protected ImageBinaryPanel() {
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, this);
        }
    }

    public void setBinaryImage(ImageUInt8 binaryImage) {
        this.binaryImage = binaryImage;
        VisualizeBinaryData.renderBinary(binaryImage, this.img);
    }

    public BufferedImage getImage() {
        return this.img;
    }
}

