/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.core.option.AbstractOptionHandler;
import adams.data.image.AbstractImageContainer;

public abstract class AbstractMultiImageOperation<T extends AbstractImageContainer>
extends AbstractOptionHandler {
    public abstract int numImagesRequired();

    protected boolean checkSameDimensions(T image1, T image2) {
        return image1.getWidth() == image2.getWidth() && image1.getHeight() == image2.getHeight();
    }

    protected void check(T[] images) {
        if (images == null || images.length == 0) {
            throw new IllegalStateException("No images provided!");
        }
        if (this.numImagesRequired() > 0 && images.length != this.numImagesRequired()) {
            throw new IllegalStateException("Required number of images differs from supplied number: " + this.numImagesRequired() + " != " + images.length);
        }
    }

    protected abstract T[] doProcess(T[] var1);

    public T[] process(T[] images) {
        this.check((AbstractImageContainer[])images);
        return this.doProcess((AbstractImageContainer[])images);
    }
}

