/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.data.image.ImageAnchor;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class ImageAnchorHelper {
    public static int calculateX(int width, double x) {
        int result = x <= 1.0 ? (int)Math.round((double)width * x) : (int)x;
        return result;
    }

    public static int calculateY(int height, double y) {
        int result = y <= 1.0 ? (int)Math.round((double)height * y) : (int)y;
        return result;
    }

    public static Point[] calculateCorners(BufferedImage img, ImageAnchor anchor, double x, double y, double width, double height) {
        return ImageAnchorHelper.calculateCorners(img.getWidth(), img.getHeight(), anchor, x, y, width, height);
    }

    public static Point[] calculateCorners(int imgWidth, int imgHeight, ImageAnchor anchor, double x, double y, double width, double height) {
        int topOrig;
        int leftOrig;
        int xAct = ImageAnchorHelper.calculateX(imgWidth, x);
        int yAct = ImageAnchorHelper.calculateY(imgHeight, y);
        int widthAct = ImageAnchorHelper.calculateX(imgWidth, width);
        int heightAct = ImageAnchorHelper.calculateY(imgHeight, height);
        int top = yAct;
        int middle = imgHeight / 2 - heightAct / 2 - yAct / 2;
        int bottom = imgHeight - heightAct - yAct;
        int left = xAct;
        int center = imgWidth / 2 - widthAct / 2 - xAct / 2;
        int right = imgWidth - widthAct - xAct;
        switch (anchor) {
            case TOP_LEFT: {
                leftOrig = left;
                topOrig = top;
                break;
            }
            case TOP_CENTER: {
                leftOrig = center;
                topOrig = top;
                break;
            }
            case TOP_RIGHT: {
                leftOrig = right;
                topOrig = top;
                break;
            }
            case MIDDLE_LEFT: {
                leftOrig = left;
                topOrig = middle;
                break;
            }
            case MIDDLE_CENTER: {
                leftOrig = center;
                topOrig = middle;
                break;
            }
            case MIDDLE_RIGHT: {
                leftOrig = right;
                topOrig = middle;
                break;
            }
            case BOTTOM_LEFT: {
                leftOrig = left;
                topOrig = bottom;
                break;
            }
            case BOTTOM_CENTER: {
                leftOrig = center;
                topOrig = bottom;
                break;
            }
            case BOTTOM_RIGHT: {
                leftOrig = right;
                topOrig = bottom;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled anchor: " + (Object)((Object)anchor));
            }
        }
        Point[] result = new Point[]{new Point(leftOrig, topOrig), new Point(leftOrig + widthAct - 1, topOrig + heightAct - 1)};
        return result;
    }
}

