/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.image.transformer.Binary;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class BinaryMask
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected int m_Threshold;
    protected ReplacementType m_ReplacementType;
    protected Color m_ReplacementColor;

    public String globalInfo() {
        return "Generates a binary image from the input and uses this mask to determine which pixels get replaced by the specified replacement color.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("threshold", "threshold", (Object)128, (Number)0, (Number)255);
        this.m_OptionManager.add("replacement-type", "replacementType", (Object)ReplacementType.REPLACE_WHITE_PIXELS);
        this.m_OptionManager.add("replacement-color", "replacementColor", (Object)Color.WHITE);
    }

    public void setThreshold(int value) {
        if (value >= 0 && value <= 255) {
            this.m_Threshold = value;
            this.reset();
        } else {
            this.getLogger().severe("Threshold has to be 0 <= x <= 255, provided: " + value);
        }
    }

    public int getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold that determines whether a grayscale pixel will become black (below) or white (equal to or above).";
    }

    public void setReplacementType(ReplacementType value) {
        this.m_ReplacementType = value;
        this.reset();
    }

    public ReplacementType getReplacementType() {
        return this.m_ReplacementType;
    }

    public String replacementTypeTipText() {
        return "The type of replacement to perform.";
    }

    public void setReplacementColor(Color value) {
        this.m_ReplacementColor = value;
        this.reset();
    }

    public Color getReplacementColor() {
        return this.m_ReplacementColor;
    }

    public String replacementColorTipText() {
        return "The color to replace pixels selected by the replacement type with.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"threshold", (Object)this.m_Threshold, (String)"threshold: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"replacementType", (Object)((Object)this.m_ReplacementType), (String)", type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"replacementColor", (Object)this.m_ReplacementColor, (String)", color: ");
        return result;
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        Binary binary = new Binary();
        binary.setThreshold(this.m_Threshold);
        BufferedImageContainer[] mask = (BufferedImageContainer[])binary.transform((AbstractImageContainer)img);
        BufferedImage bimage = (BufferedImage)mask[0].getImage();
        BufferedImage image = (BufferedImage)img.getImage();
        int width = image.getWidth();
        int height = image.getHeight();
        int color = this.m_ReplacementColor.getRGB();
        for (int y = 0; y < height; ++y) {
            block5: for (int x = 0; x < width; ++x) {
                int current = bimage.getRGB(x, y) & 0xFFFFFF;
                switch (this.m_ReplacementType) {
                    case REPLACE_WHITE_PIXELS: {
                        if (current <= 0) continue block5;
                        image.setRGB(x, y, color);
                        continue block5;
                    }
                    case REPLACE_BLACK_PIXELS: {
                        if (current != 0) continue block5;
                        image.setRGB(x, y, color);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled replacement type: " + (Object)((Object)this.m_ReplacementType));
                    }
                }
            }
        }
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        result[0].setImage((Object)image);
        return result;
    }

    public static enum ReplacementType {
        REPLACE_WHITE_PIXELS,
        REPLACE_BLACK_PIXELS;

    }
}

