/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.annotation.DeprecatedClass;
import adams.data.image.BufferedImageContainer;
import adams.data.image.ImageAnchor;
import adams.data.image.ImageAnchorHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.image.transformer.Cropping;
import adams.data.image.transformer.crop.RelativeCrop;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import java.awt.Point;
import java.awt.image.BufferedImage;

@Deprecated
@DeprecatedClass(useInstead={Cropping.class, RelativeCrop.class})
public class Crop
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected double m_X;
    protected double m_Y;
    protected double m_Width;
    protected double m_Height;
    protected ImageAnchor m_Anchor;

    public String globalInfo() {
        return "Crops the image to specified width and height. Where the crop rectangle starts is defined by the X and Y position and the anchor.\n\nDEPRECATED\nUse " + Cropping.class.getName() + " in conjunction with " + RelativeCrop.class.getName() + " instead.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("y", "Y", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("width", "width", (Object)1.0, (Number)1.0E-5, null);
        this.m_OptionManager.add("height", "height", (Object)1.0, (Number)1.0E-5, null);
        this.m_OptionManager.add("anchor", "anchor", (Object)ImageAnchor.TOP_LEFT);
    }

    public void setX(double value) {
        if (value >= 0.0) {
            this.m_X = value;
            this.reset();
        } else {
            this.getLogger().severe("X has to be >=0, provided: " + value);
        }
    }

    public double getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The horizontal pixel position (0-1: percent; >1: pixels).";
    }

    public void setY(double value) {
        if (value >= 0.0) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getLogger().severe("Y has to be >=0, provided: " + value);
        }
    }

    public double getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The vertical pixel position (0-1: percent; >1: pixels).";
    }

    public void setWidth(double value) {
        if (value > 0.0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getLogger().severe("Width has to be >0, provided: " + value);
        }
    }

    public double getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the crop rectangle (0-1: percent; >1: pixels).";
    }

    public void setHeight(double value) {
        if (value > 0.0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getLogger().severe("Height has to be >0, provided: " + value);
        }
    }

    public double getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the crop rectangle (0-1: percent; >1: pixels).";
    }

    public void setAnchor(ImageAnchor value) {
        this.m_Anchor = value;
        this.reset();
    }

    public ImageAnchor getAnchor() {
        return this.m_Anchor;
    }

    public String anchorTipText() {
        return "Defines where to anchor the position on the crop rectangle.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        Point[] corners = ImageAnchorHelper.calculateCorners((BufferedImage)img.getImage(), this.m_Anchor, this.m_X, this.m_Y, this.m_Width, this.m_Height);
        int leftOrig = (int)corners[0].getX();
        int topOrig = (int)corners[0].getY();
        int width = (int)(corners[1].getX() - corners[0].getX() + 1.0);
        int height = (int)(corners[1].getY() - corners[0].getY() + 1.0);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("x=" + this.m_X + ", y=" + this.m_Y + ", width=" + this.m_Width + ", height=" + this.m_Height + ", anchor=" + (Object)((Object)this.m_Anchor));
            this.getLogger().info("  --> top-left=" + corners[0] + ", bottom-right=" + corners[1]);
        }
        int heightOrig = img.getHeight();
        int widthOrig = img.getWidth();
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            int yOrig = topOrig + y;
            if (yOrig < 0 || yOrig >= heightOrig) continue;
            for (int x = 0; x < width; ++x) {
                int xOrig = leftOrig + x;
                if (xOrig < 0 || xOrig >= widthOrig) continue;
                image.setRGB(x, y, ((BufferedImage)img.getImage()).getRGB(xOrig, yOrig));
            }
        }
        result[0].setImage((Object)image);
        Report report = result[0].getReport();
        if (report != null) {
            report.addField((AbstractField)new Field("Crop.Left", DataType.NUMERIC));
            report.addField((AbstractField)new Field("Crop.Top", DataType.NUMERIC));
            report.addField((AbstractField)new Field("Crop.Right", DataType.NUMERIC));
            report.addField((AbstractField)new Field("Crop.Bottom", DataType.NUMERIC));
            report.setNumericValue("Crop.Left", (double)leftOrig);
            report.setNumericValue("Crop.Top", (double)topOrig);
            report.setNumericValue("Crop.Right", (double)(leftOrig + width - 1));
            report.setNumericValue("Crop.Bottom", (double)(topOrig + height - 1));
        }
        return result;
    }
}

