/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej;

import adams.data.Notes;
import adams.data.image.AbstractImageContainer;
import adams.data.imagej.ImagePlusContainer;
import adams.data.report.Report;
import adams.env.Environment;
import ij.ImagePlus;
import java.awt.Image;
import java.io.File;
import java.util.Date;

public class ImageJHelper {
    public static final String PROPERTY_PLUGINS_DIR = "plugins.dir";
    public static final String ENV_IMAGEJ_DIR = "ADAMS_IMAGEJ_DIR";
    protected static Boolean m_PluginsDirectorySet;

    public static synchronized void setPluginsDirectory() {
        if (m_PluginsDirectorySet == null) {
            File file;
            String dir = null;
            if (System.getenv(ENV_IMAGEJ_DIR) != null && (file = new File(System.getenv(ENV_IMAGEJ_DIR))).exists() && file.isDirectory()) {
                dir = file.getAbsolutePath();
            }
            if (dir == null) {
                dir = Environment.getInstance().getHome() + File.separator + "imagej";
            }
            System.setProperty(PROPERTY_PLUGINS_DIR, dir);
            m_PluginsDirectorySet = true;
        }
    }

    public static ImagePlusContainer toImagePlusContainer(AbstractImageContainer cont) {
        if (cont instanceof ImagePlusContainer) {
            return (ImagePlusContainer)cont;
        }
        Report report = cont.getReport().getClone();
        Notes notes = cont.getNotes().getClone();
        ImagePlusContainer result = new ImagePlusContainer();
        result.setImage(new ImagePlus("" + new Date(), (Image)cont.toBufferedImage()));
        result.setReport(report);
        result.setNotes(notes);
        return result;
    }
}

