/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagemagick.dcraw;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.data.imagemagick.AbstractImageOperation;
import adams.data.imagemagick.DCRawHelper;
import java.io.File;

public abstract class AbstractDcrawOperation
extends AbstractImageOperation {
    private static final long serialVersionUID = 4447009209054143230L;

    @Override
    protected String check(PlaceholderFile input, PlaceholderFile output) {
        if (!DCRawHelper.isDcrawAvailable()) {
            return DCRawHelper.getMissingDcrawErrorMessage();
        }
        return super.check(input, output);
    }

    protected String move(PlaceholderFile input, PlaceholderFile output) {
        String result = null;
        PlaceholderFile tmp = FileUtils.replaceExtension((PlaceholderFile)input, (String)".ppm");
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Moving tmp file '" + tmp + "' to '" + output + "'...");
        }
        try {
            if (!FileUtils.move((File)tmp, (File)output)) {
                result = "Failed to move file '" + tmp + "' to '" + output + "'!";
            }
        }
        catch (Exception e) {
            result = Utils.handleException((LoggingObject)this, (String)("Failed to move file '" + tmp + "' to '" + output + "'!"), (Throwable)e);
        }
        if (result == null && this.isLoggingEnabled()) {
            this.getLogger().info("Moved tmp file '" + tmp + "' successfully to '" + output + "'.");
        }
        return result;
    }
}

