/*
 * Decompiled with CFR 0.152.
 */
package adams.data.lire.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.data.statistics.StatUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BasicFeatures
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Generates features using " + net.semanticmetadata.lire.imageanalysis.BasicFeatures.class.getName() + ".\n" + "For more information on the LIRE project, see:\n" + "http://code.google.com/p/lire/";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("Brightness", DataType.NUMERIC);
        result.add("Clipping", DataType.NUMERIC);
        result.add("Contrast", DataType.NUMERIC);
        result.add("HueCount", DataType.NUMERIC);
        result.add("Saturation", DataType.NUMERIC);
        result.add("Complexity", DataType.NUMERIC);
        result.add("Skew", DataType.NUMERIC);
        result.add("Energy", DataType.NUMERIC);
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        net.semanticmetadata.lire.imageanalysis.BasicFeatures features = new net.semanticmetadata.lire.imageanalysis.BasicFeatures();
        features.extract(image);
        double[] histo = features.getDoubleHistogram();
        List[] result = new List[]{new ArrayList()};
        result[0].addAll(Arrays.asList(StatUtils.toNumberArray((double[])histo)));
        return result;
    }
}

