/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.BoofCVDetectLines;
import adams.gui.visualization.image.AbstractImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import boofcv.alg.feature.detect.line.LineImageOps;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class BoofCVDetectLinesImageOverlay
extends AbstractImageOverlay {
    private static final long serialVersionUID = -4190767869077702132L;
    protected Color m_Color;
    protected SpreadSheet m_Lines;

    public String globalInfo() {
        return "Overlays the image with lines detected by " + BoofCVDetectLines.class.getName() + ".";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color for the lines.";
    }

    public void setLines(SpreadSheet value) {
        this.m_Lines = value;
    }

    public SpreadSheet getLines() {
        return this.m_Lines;
    }

    protected void doImageChanged(ImagePanel.PaintPanel panel) {
    }

    protected void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        if (this.m_Lines == null) {
            return;
        }
        g.setColor(this.m_Color);
        Graphics2D g2 = (Graphics2D)g;
        for (Row row : this.m_Lines.rows()) {
            float y;
            float sx = row.getCell(1).toDouble().floatValue();
            float sy = row.getCell(2).toDouble().floatValue();
            float x = row.getCell(3).toDouble().floatValue();
            LineParametric2D_F32 lp = new LineParametric2D_F32(x, y = row.getCell(4).toDouble().floatValue(), sx, sy);
            LineSegment2D_F32 ls = LineImageOps.convert((LineParametric2D_F32)lp, (int)panel.getWidth(), (int)panel.getHeight());
            if (ls == null) continue;
            g2.drawLine((int)ls.a.x, (int)ls.a.y, (int)ls.b.x, (int)ls.b.y);
        }
    }
}

