/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.metric.ClosestPoint2D_F32;
import georegression.struct.line.LineGeneral2D_F32;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LinePolar2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;

public class UtilLine2D_F32 {
    public static float acuteAngle(LineGeneral2D_F32 a, LineGeneral2D_F32 b) {
        float lb;
        float la = (float)Math.sqrt(a.A * a.A + a.B * a.B);
        float value = (a.A * b.A + a.B * b.B) / (la * (lb = (float)Math.sqrt(b.A * b.A + b.B * b.B)));
        if (value < -1.0f) {
            value = -1.0f;
        } else if (value > 1.0f) {
            value = 1.0f;
        }
        return (float)Math.acos(value);
    }

    public static float acuteAngleN(LineGeneral2D_F32 a, LineGeneral2D_F32 b) {
        float value = a.A * b.A + a.B * b.B;
        if (value < -1.0f) {
            value = -1.0f;
        } else if (value > 1.0f) {
            value = 1.0f;
        }
        return (float)Math.acos(value);
    }

    public static LineParametric2D_F32 convert(LinePolar2D_F32 src, LineParametric2D_F32 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F32();
        }
        float c = (float)Math.cos(src.angle);
        float s = (float)Math.sin(src.angle);
        ret.p.set(c * src.distance, s * src.distance);
        ret.slope.set(-s, c);
        return ret;
    }

    public static LineGeneral2D_F32 convert(LinePolar2D_F32 src, LineGeneral2D_F32 ret) {
        if (ret == null) {
            ret = new LineGeneral2D_F32();
        }
        float c = (float)Math.cos(src.angle);
        float s = (float)Math.sin(src.angle);
        ret.A = c;
        ret.B = s;
        ret.C = -src.distance;
        return ret;
    }

    public static LinePolar2D_F32 convert(LineGeneral2D_F32 src, LinePolar2D_F32 ret) {
        if (ret == null) {
            ret = new LinePolar2D_F32();
        }
        float r = (float)Math.sqrt(src.A * src.A + src.B * src.B);
        float sign = src.C < 0.0f ? -1.0f : 1.0f;
        ret.angle = (float)Math.atan2(-sign * src.B / r, -sign * src.A / r);
        ret.distance = sign * src.C / r;
        return ret;
    }

    public static LineParametric2D_F32 convert(LineSegment2D_F32 src, LineParametric2D_F32 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F32();
        }
        ret.p.set(src.a);
        ret.slope.set(src.slopeX(), src.slopeY());
        return ret;
    }

    public static LineGeneral2D_F32 convert(LineSegment2D_F32 src, LineGeneral2D_F32 ret) {
        if (ret == null) {
            ret = new LineGeneral2D_F32();
        }
        ret.A = src.a.y - src.b.y;
        ret.B = src.b.x - src.a.x;
        ret.C = -(ret.A * src.a.x + ret.B * src.a.y);
        return ret;
    }

    public static LinePolar2D_F32 convert(LineParametric2D_F32 src, LinePolar2D_F32 ret) {
        if (ret == null) {
            ret = new LinePolar2D_F32();
        }
        float t = ClosestPoint2D_F32.closestPointT(src, new Point2D_F32());
        float cpX = src.slope.x * t + src.p.x;
        float cpY = src.slope.y * t + src.p.y;
        ret.angle = (float)Math.atan2(cpY, cpX);
        ret.distance = (float)Math.sqrt(cpX * cpX + cpY * cpY);
        return ret;
    }

    public static LineGeneral2D_F32 convert(LineParametric2D_F32 src, LineGeneral2D_F32 ret) {
        if (ret == null) {
            ret = new LineGeneral2D_F32();
        }
        float x1 = src.p.x + src.slope.x;
        float y1 = src.p.y + src.slope.y;
        ret.A = src.p.y - y1;
        ret.B = x1 - src.p.x;
        ret.C = src.p.x * y1 - x1 * src.p.y;
        return ret;
    }

    public static LineParametric2D_F32 convert(LineGeneral2D_F32 src, LineParametric2D_F32 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F32();
        }
        ret.slope.x = src.B;
        ret.slope.y = -src.A;
        if (Math.abs(src.B) > Math.abs(src.A)) {
            ret.p.y = -src.C / src.B;
            ret.p.x = 0.0f;
        } else {
            ret.p.x = -src.C / src.A;
            ret.p.y = 0.0f;
        }
        return ret;
    }
}

