/*
 * Decompiled with CFR 0.152.
 */
package georegression.misc.autocode;

import georegression.misc.autocode.ConvertFile32From64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Generate32From64App {
    File rootDirectory;

    public Generate32From64App(String sourceCodeRoot) {
        this.rootDirectory = new File(sourceCodeRoot);
        if (!this.rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Must specify a directory");
        }
    }

    public void process() {
        this.processDirectory(this.rootDirectory);
    }

    private void processDirectory(File directory) {
        File[] files;
        System.out.println("---- Directory " + directory);
        for (File f : files = directory.listFiles()) {
            if (!f.getName().endsWith("_F64.java")) continue;
            this.processFile(f);
        }
        for (File f : files) {
            if (!f.isDirectory() || f.isHidden()) continue;
            this.processDirectory(f);
        }
    }

    private void processFile(File f) {
        try {
            System.out.println("Examining " + f.getName());
            new ConvertFile32From64(f).process();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String[] directories;
        for (String dir : directories = new String[]{"main/src", "main/test", "experimental/src", "experimental/test"}) {
            new Generate32From64App(dir).process();
        }
    }
}

