/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.affine;

import georegression.struct.affine.Affine;

public class Affine2D_F32
implements Affine<Affine2D_F32> {
    public float a11;
    public float a12;
    public float a21;
    public float a22;
    public float tx;
    public float ty;

    public Affine2D_F32(float a11, float a12, float a21, float a22, float tx, float ty) {
        this.a11 = a11;
        this.a12 = a12;
        this.a21 = a21;
        this.a22 = a22;
        this.tx = tx;
        this.ty = ty;
    }

    public Affine2D_F32() {
        this.reset();
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Affine2D_F32 createInstance() {
        return new Affine2D_F32();
    }

    @Override
    public void set(Affine2D_F32 target) {
        this.a11 = target.a11;
        this.a12 = target.a12;
        this.a21 = target.a21;
        this.a22 = target.a22;
        this.tx = target.tx;
        this.ty = target.ty;
    }

    @Override
    public Affine2D_F32 concat(Affine2D_F32 second, Affine2D_F32 ret) {
        if (ret == null) {
            ret = new Affine2D_F32();
        }
        ret.a11 = second.a11 * this.a11 + second.a12 * this.a21;
        ret.a12 = second.a11 * this.a12 + second.a12 * this.a22;
        ret.a21 = second.a21 * this.a11 + second.a22 * this.a21;
        ret.a22 = second.a21 * this.a12 + second.a22 * this.a22;
        ret.tx = second.a11 * this.tx + second.a12 * this.ty + second.tx;
        ret.ty = second.a21 * this.tx + second.a22 * this.ty + second.ty;
        return ret;
    }

    @Override
    public Affine2D_F32 invert(Affine2D_F32 inverse) {
        Affine2D_F32 inv = new Affine2D_F32();
        float div = this.a11 * this.a22 - this.a12 * this.a21;
        inv.a11 = this.a22 / div;
        inv.a12 = -this.a12 / div;
        inv.a21 = -this.a21 / div;
        inv.a22 = this.a11 / div;
        inv.tx = -(inv.a11 * this.tx + inv.a12 * this.ty);
        inv.ty = -(inv.a21 * this.tx + inv.a22 * this.ty);
        return inv;
    }

    @Override
    public void reset() {
        this.a22 = 1.0f;
        this.a11 = 1.0f;
        this.a21 = 0.0f;
        this.a12 = 0.0f;
        this.ty = 0.0f;
        this.tx = 0.0f;
    }

    public Affine2D_F32 copy() {
        return new Affine2D_F32(this.a11, this.a12, this.a21, this.a22, this.tx, this.ty);
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.format("[ %5.2fe %5.2fe %5.2fe ; %5.2fe %5.2fe %5.2fe ]", Float.valueOf(this.a11), Float.valueOf(this.a12), Float.valueOf(this.tx), Float.valueOf(this.a21), Float.valueOf(this.a22), Float.valueOf(this.ty));
    }
}

