/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.point;

import georegression.struct.GeoTuple4D_F32;
import georegression.struct.point.Point4D_F32;

public class Vector4D_F32
extends GeoTuple4D_F32<Vector4D_F32> {
    public Vector4D_F32(float x, float y, float z, float w) {
        super(x, y, z, w);
    }

    public Vector4D_F32() {
    }

    public Vector4D_F32(Point4D_F32 a, Point4D_F32 b) {
        this.x = b.getX() - a.getX();
        this.y = b.getY() - a.getY();
        this.z = b.getZ() - a.getZ();
        this.w = b.getW() - a.getW();
    }

    public void set(Vector4D_F32 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
    }

    public Vector4D_F32 times(float scalar) {
        return new Vector4D_F32(this.x * scalar, this.y * scalar, this.z * scalar, this.w * scalar);
    }

    @Override
    public Vector4D_F32 copy() {
        return new Vector4D_F32(this.x, this.y, this.z, this.w);
    }

    @Override
    public Vector4D_F32 createNewInstance() {
        return new Vector4D_F32();
    }

    public String toString() {
        return "V( " + this.x + " " + this.y + " " + this.z + " " + this.w + " )";
    }

    public void normalize() {
        float r = this.norm();
        this.x /= r;
        this.y /= r;
        this.z /= r;
        this.w /= r;
    }

    public float dot(Vector4D_F32 a) {
        return this.x * a.x + this.y * a.y + this.z * a.z + this.w * a.w;
    }
}

