/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractInPlaceSpreadSheetConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;

public class SpreadSheetAddSumRow
extends AbstractInPlaceSpreadSheetConversion {
    private static final long serialVersionUID = -6368389681769797003L;
    protected SpreadSheetColumnRange m_Columns;

    public String globalInfo() {
        return "Adds a row with 'sum' formulas for the specified columns.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The range of columns to add the 'sum' formula for; " + this.m_Columns.getExample();
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result = this.m_NoCopy ? input : input.getClone();
        this.m_Columns.setSpreadSheet(result);
        int[] cols = this.m_Columns.getIntIndices();
        DataRow row = result.addRow();
        for (int i = 0; i < cols.length; ++i) {
            String from = SpreadSheet.getCellPosition((int)0, (int)cols[i]);
            String to = SpreadSheet.getCellPosition((int)(result.getRowCount() - 2), (int)cols[i]);
            row.addCell(cols[i]).setContent("=SUM(" + from + ":" + to + ")");
        }
        return result;
    }
}

