/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import java.util.ArrayList;

public class SpreadSheetToDoubleMatrix
extends AbstractConversion {
    private static final long serialVersionUID = 4117708470154504868L;

    public String globalInfo() {
        return "Turns a spreadsheet into a double matrix, using only the numeric columns.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Double[][].class;
    }

    protected Object doConvert() throws Exception {
        int i;
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        ArrayList<Integer> numeric = new ArrayList<Integer>();
        for (i = 0; i < sheet.getColumnCount(); ++i) {
            if (!sheet.isNumeric(i, true)) continue;
            numeric.add(i);
        }
        if (numeric.size() == 0) {
            throw new IllegalStateException("No numeric columns in spreadsheet!");
        }
        Double[][] result = new Double[sheet.getRowCount()][numeric.size()];
        for (int n = 0; n < sheet.getRowCount(); ++n) {
            DataRow row = sheet.getRow(n);
            for (i = 0; i < numeric.size(); ++i) {
                result[n][i] = !row.hasCell(((Integer)numeric.get(i)).intValue()) ? Double.valueOf(Double.NaN) : row.getCell(((Integer)numeric.get(i)).intValue()).toDouble();
            }
        }
        return result;
    }
}

