/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.data.DateFormatString;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractFormattedSpreadSheetWriter;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import java.io.Writer;
import java.util.Date;
import java.util.logging.Level;

public class FixedTabularSpreadSheetWriter
extends AbstractFormattedSpreadSheetWriter {
    private static final long serialVersionUID = 3420511187768902829L;
    protected int m_ColumnWidth;
    protected String m_NewLine;
    protected DateFormatString m_DateFormat;
    protected DateFormatString m_DateTimeFormat;
    protected DateFormatString m_TimeFormat;
    protected boolean m_OnlyFloat;

    public String globalInfo() {
        return "Outputs the spreadsheet in a simple tabular format with fixed column width, as used by dot matrix printers in days gone by.";
    }

    public String getFormatDescription() {
        return "Fixed tabular format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"txt"};
    }

    public SpreadSheetReader getCorrespondingReader() {
        return null;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("enncoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("column-width", "columnWidth", (Object)10, (Number)1, null);
        this.m_OptionManager.add("new-line", "newLine", (Object)Utils.backQuoteChars((String)System.getProperty("line.separator")));
        this.m_OptionManager.add("date-format", "dateFormat", (Object)new DateFormatString("yyyy-MM-dd"));
        this.m_OptionManager.add("datetime-format", "dateTimeFormat", (Object)new DateFormatString("yyyy-MM-dd HH:mm:ss"));
        this.m_OptionManager.add("time-format", "timeFormat", (Object)new DateFormatString("HH:mm:ss"));
        this.m_OptionManager.add("only-float", "onlyFloat", (Object)false);
    }

    public void setColumnWidth(int value) {
        this.m_ColumnWidth = value;
        this.reset();
    }

    public int getColumnWidth() {
        return this.m_ColumnWidth;
    }

    public String columnWidthTipText() {
        return "The width in characters to use for each column.";
    }

    public void setNewLine(String value) {
        this.m_NewLine = Utils.unbackQuoteChars((String)value);
        this.reset();
    }

    public String getNewLine() {
        return Utils.backQuoteChars((String)this.m_NewLine);
    }

    public String newLineTipText() {
        return "The newline character(s) to use for the columns; use '\\r' for carriage return and '\\n' for line feed; Linux/Unix use '\\n', Windows uses '\\r\\n' and old Macs use '\\r'.";
    }

    public void setDateFormat(DateFormatString value) {
        this.m_DateFormat = value;
        this.reset();
    }

    public DateFormatString getDateFormat() {
        return this.m_DateFormat;
    }

    public String dateFormatTipText() {
        return "The format for dates.";
    }

    public void setDateTimeFormat(DateFormatString value) {
        this.m_DateTimeFormat = value;
        this.reset();
    }

    public DateFormatString getDateTimeFormat() {
        return this.m_DateTimeFormat;
    }

    public String dateTimeFormatTipText() {
        return "The format for date/times.";
    }

    public void setTimeFormat(DateFormatString value) {
        this.m_TimeFormat = value;
        this.reset();
    }

    public DateFormatString getTimeFormat() {
        return this.m_TimeFormat;
    }

    public String timeFormatTipText() {
        return "The format for times.";
    }

    public void setOnlyFloat(boolean value) {
        this.m_OnlyFloat = value;
        this.reset();
    }

    public boolean getOnlyFloat() {
        return this.m_OnlyFloat;
    }

    public String onlyFloatTipText() {
        return "If enabled, all numbers are treated as float rather than distinguishing between long and double.";
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.WRITER;
    }

    protected void addSeparatorLine(SpreadSheet content, Writer writer) throws Exception {
        int i;
        StringBuilder col = new StringBuilder();
        for (i = 0; i < this.m_ColumnWidth; ++i) {
            col.append("-");
        }
        writer.write("+");
        for (i = 0; i < content.getColumnCount(); ++i) {
            writer.write(col.toString());
            writer.write("+");
        }
        writer.write(this.m_NewLine);
    }

    protected String pad(String s, boolean leftPad) {
        StringBuilder result = new StringBuilder(s);
        while (result.length() < this.m_ColumnWidth) {
            if (leftPad) {
                result.insert(0, " ");
                continue;
            }
            result.append(" ");
        }
        if (result.length() > this.m_ColumnWidth) {
            if (leftPad) {
                result.delete(0, result.length() - this.m_ColumnWidth);
            } else {
                result.delete(this.m_ColumnWidth, result.length());
            }
        }
        return result.toString();
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        boolean result = true;
        try {
            int i;
            DateFormat dformat = this.m_DateFormat.toDateFormat();
            DateFormat dtformat = this.m_DateTimeFormat.toDateFormat();
            DateFormat tformat = this.m_TimeFormat.toDateFormat();
            String missing = this.pad(this.m_MissingValue, false);
            this.addSeparatorLine(content, writer);
            HeaderRow row = content.getHeaderRow();
            writer.write("|");
            for (i = 0; i < content.getColumnCount(); ++i) {
                if (!row.hasCell(i) || row.getCell(i).isMissing()) {
                    writer.write(missing);
                } else {
                    writer.write(this.pad(row.getCell(i).getContent(), false));
                }
                writer.write("|");
            }
            writer.write(this.m_NewLine);
            this.addSeparatorLine(content, writer);
            for (Row drow : content.rows()) {
                writer.write("|");
                for (i = 0; i < content.getColumnCount(); ++i) {
                    if (!drow.hasCell(i) || drow.getCell(i).isMissing()) {
                        writer.write(missing);
                    } else {
                        Cell cell = drow.getCell(i);
                        switch (cell.getContentType()) {
                            case LONG: {
                                if (this.m_OnlyFloat) {
                                    writer.write(this.pad(this.format(drow.getCell(i).toDouble()), true));
                                    break;
                                }
                                writer.write(this.pad(drow.getCell(i).toLong().toString(), true));
                                break;
                            }
                            case DOUBLE: {
                                writer.write(this.pad(this.format(drow.getCell(i).toDouble()), true));
                                break;
                            }
                            case DATE: {
                                writer.write(this.pad(dformat.format(drow.getCell(i).toDate()), false));
                                break;
                            }
                            case DATETIME: {
                                writer.write(this.pad(dtformat.format((Date)drow.getCell(i).toDateTime()), false));
                                break;
                            }
                            case TIME: {
                                writer.write(this.pad(tformat.format((Date)drow.getCell(i).toTime()), false));
                                break;
                            }
                            case BOOLEAN: {
                                writer.write(this.pad(drow.getCell(i).toBoolean().toString(), false));
                                break;
                            }
                            default: {
                                writer.write(this.pad(drow.getCell(i).getContent(), false));
                            }
                        }
                    }
                    writer.write("|");
                }
                writer.write(this.m_NewLine);
            }
            this.addSeparatorLine(content, writer);
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed writing spreadsheet data", e);
        }
        return result;
    }
}

