/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.core.ClassLister;
import adams.core.QuickInfoSupporter;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.CellLocation;
import java.util.Iterator;

public abstract class AbstractCellFinder
extends AbstractOptionHandler
implements ShallowCopySupporter<AbstractCellFinder>,
QuickInfoSupporter {
    private static final long serialVersionUID = 3647241823201101006L;

    public String getQuickInfo() {
        return null;
    }

    protected void check(SpreadSheet sheet) {
        if (sheet == null) {
            throw new IllegalArgumentException("No spreadsheet provided!");
        }
    }

    protected abstract Iterator<CellLocation> doFindCells(SpreadSheet var1);

    public Iterator<CellLocation> findCells(SpreadSheet sheet) {
        this.check(sheet);
        return this.doFindCells(sheet);
    }

    public AbstractCellFinder shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractCellFinder shallowCopy(boolean expand) {
        return (AbstractCellFinder)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public static String[] getCellFinders() {
        return ClassLister.getSingleton().getClassnames(AbstractCellFinder.class);
    }

    public static AbstractCellFinder forName(String classname, String[] options) {
        AbstractCellFinder result;
        try {
            result = (AbstractCellFinder)((Object)OptionUtils.forName(AbstractCellFinder.class, (String)classname, (String[])options));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractCellFinder forCommandLine(String cmdline) {
        return (AbstractCellFinder)AbstractOptionConsumer.fromString(ArrayConsumer.class, (String)cmdline);
    }
}

