/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.cellfinder.AbstractCellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.RangeIterator;
import adams.data.spreadsheet.rowfinder.ByIndex;
import adams.data.spreadsheet.rowfinder.RowFinder;
import java.util.ArrayList;
import java.util.Iterator;

public class RowFinderRange
extends AbstractCellFinder {
    private static final long serialVersionUID = 3956527986917157099L;
    protected RowFinder m_RowFinder;
    protected SpreadSheetColumnRange m_Columns;

    public String globalInfo() {
        return "Uses a row finder to locate the interesting rows.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row-finder", "rowFinder", (Object)new ByIndex());
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
    }

    public void setRowFinder(RowFinder value) {
        this.m_RowFinder = value;
        this.reset();
    }

    public RowFinder getRowFinder() {
        return this.m_RowFinder;
    }

    public String rowFinderTipText() {
        return "The row finder to use for locating the rows.";
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The columns to locate.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"rowFinder", (Object)this.m_RowFinder, (String)"row finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"columns", (Object)((Object)this.m_Columns), (String)", cols: ");
        return result;
    }

    @Override
    protected Iterator<CellLocation> doFindCells(SpreadSheet sheet) {
        this.m_Columns.setSpreadSheet(sheet);
        int[] rows = this.m_RowFinder.findRows(sheet);
        int[] cols = this.m_Columns.getIntIndices();
        if (rows.length > 0 && cols.length > 0) {
            return new RangeIterator(rows, cols);
        }
        return new ArrayList().iterator();
    }
}

