/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.random.JavaRandomInt;
import adams.data.random.RandomIntegerRangeGenerator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import gnu.trove.list.array.TIntArrayList;

public class SubSample
extends AbstractRowFinder {
    private static final long serialVersionUID = 2989233908194930918L;
    protected double m_Size;
    protected RandomIntegerRangeGenerator m_Generator;
    protected boolean m_Invert;

    public String globalInfo() {
        return "Returns the indices of a subsample of rows.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("size", "size", (Object)1.0, (Number)0.0, null);
        this.m_OptionManager.add("generator", "generator", (Object)new JavaRandomInt());
        this.m_OptionManager.add("invert", "invert", (Object)false);
    }

    public void setSize(double value) {
        if (value > 0.0) {
            this.m_Size = value;
            this.reset();
        } else {
            this.getLogger().warning("Sample size must be >0, provided: " + value);
        }
    }

    public double getSize() {
        return this.m_Size;
    }

    public String sizeTipText() {
        return "The size of the sample: 0-1 = percentage, >1 absolute number of rows.";
    }

    public void setGenerator(RandomIntegerRangeGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public RandomIntegerRangeGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The random number generator to use for selecting the elements.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If enabled, the inverse of the elements is returned.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"size", (Object)this.m_Size, (String)"size: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)this.m_Generator, (String)", generator: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"invert", (boolean)this.m_Invert, (String)"inverted", (String)", ");
        return result;
    }

    @Override
    protected int[] doFindRows(SpreadSheet data) {
        int i;
        int size = this.m_Size > 1.0 ? (int)Math.round(this.m_Size) : (int)Math.round((double)data.getRowCount() * this.m_Size);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Size of sample: " + size);
        }
        TIntArrayList available = new TIntArrayList();
        for (i = 0; i < data.getRowCount(); ++i) {
            available.add(i);
        }
        TIntArrayList result = new TIntArrayList();
        this.m_Generator.setMinValue(0);
        while (size > 0) {
            if (available.size() == 1) {
                i = 0;
            } else {
                this.m_Generator.setMaxValue(available.size() - 1);
                i = this.m_Generator.next().intValue();
            }
            result.add(available.get(i));
            available.removeAt(i);
            --size;
        }
        if (this.m_Invert) {
            result = available;
        } else {
            result.sort();
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Indices: " + result);
        }
        return result.toArray();
    }
}

