/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowscore.AbstractRowScore;
import java.util.ArrayList;
import java.util.Arrays;

public class MultiRowScore
extends AbstractRowScore {
    private static final long serialVersionUID = -9037884201569670797L;
    protected AbstractRowScore[] m_RowScores;

    public String globalInfo() {
        return "Applies the specified row score algorithms sequentially to the row and combines the output.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row-score", "rowScores", (Object)new AbstractRowScore[0]);
    }

    public void setRowScores(AbstractRowScore[] value) {
        this.m_RowScores = value;
        this.reset();
    }

    public AbstractRowScore[] getRowScores() {
        return this.m_RowScores;
    }

    public String rowScoresTipText() {
        return "The row score algorithms to apply.";
    }

    @Override
    public int getNumScores() {
        int result = 0;
        for (AbstractRowScore score : this.m_RowScores) {
            result += score.getNumScores();
        }
        return result;
    }

    @Override
    protected Double[] doCalculateScore(SpreadSheet sheet, int rowIndex) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (AbstractRowScore score : this.m_RowScores) {
            Double[] scores = score.calculateScore(sheet, rowIndex);
            if (scores == null) {
                for (int i = 0; i < score.getNumScores(); ++i) {
                    result.add(null);
                }
                continue;
            }
            result.addAll(Arrays.asList(scores));
        }
        return result.toArray(new Double[result.size()]);
    }
}

