/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowscore.AbstractRowScore;

public class NonMissing
extends AbstractRowScore {
    private static final long serialVersionUID = -9037884201569670797L;

    public String globalInfo() {
        return "Computes the percentage of non-missing values per row.";
    }

    @Override
    public int getNumScores() {
        return 1;
    }

    @Override
    protected Double[] doCalculateScore(SpreadSheet sheet, int rowIndex) {
        Double[] result = null;
        int count = 0;
        DataRow row = sheet.getRow(rowIndex);
        for (int i = 0; i < sheet.getColumnCount(); ++i) {
            if (!row.hasCell(i) || row.getCell(i).isMissing()) continue;
            ++count;
        }
        result = new Double[]{(double)count / (double)sheet.getColumnCount()};
        return result;
    }
}

