/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowstatistic;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowstatistic.AbstractDoubleArrayRowStatistic;
import adams.data.statistics.StatUtils;

public class StandardDeviation
extends AbstractDoubleArrayRowStatistic {
    private static final long serialVersionUID = 2141252366056112668L;
    protected boolean m_IsSample;

    public String globalInfo() {
        return "Calculates the standard deviation (population or sample).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("is-sample", "isSample", (Object)true);
    }

    public void setIsSample(boolean value) {
        this.m_IsSample = value;
        this.reset();
    }

    public boolean getIsSample() {
        return this.m_IsSample;
    }

    public String isSampleTipText() {
        return "If set to true, the columns are treated as samples and not as populations.";
    }

    @Override
    protected SpreadSheet postVisit(SpreadSheet sheet, int rowIndex) {
        SpreadSheet result = this.createOutputHeader();
        DataRow row = result.addRow();
        row.addCell(0).setContent("StdDev" + (this.getIsSample() ? "" : "P"));
        row.addCell(1).setContent(Double.valueOf(StatUtils.stddev((double[])this.m_Values.toArray(), (boolean)this.getIsSample())));
        this.m_Values = null;
        return result;
    }
}

