/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowstatistic;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowstatistic.AbstractRowStatistic;
import java.util.HashMap;

public class Unique
extends AbstractRowStatistic {
    private static final long serialVersionUID = 4899075284716702404L;
    protected HashMap<Double, Integer> m_Numbers;
    protected HashMap<String, Integer> m_Labels;

    public String globalInfo() {
        return "Counts the unique occurrences of numeric/string values.";
    }

    @Override
    protected void preVisit(SpreadSheet sheet, int rowIndex) {
        this.m_Numbers = new HashMap();
        this.m_Labels = new HashMap();
    }

    @Override
    protected void doVisit(Row row, int colIndex) {
        if (row.hasCell(colIndex)) {
            Cell cell = row.getCell(colIndex);
            if (cell.isNumeric()) {
                double number = cell.toDouble();
                if (!this.m_Numbers.containsKey(number)) {
                    this.m_Numbers.put(number, 1);
                } else {
                    this.m_Numbers.put(number, this.m_Numbers.get(number) + 1);
                }
            } else if (!cell.isMissing()) {
                String label = cell.getContent();
                if (!this.m_Labels.containsKey(label)) {
                    this.m_Labels.put(label, 1);
                } else {
                    this.m_Labels.put(label, this.m_Labels.get(label) + 1);
                }
            }
        }
    }

    @Override
    protected SpreadSheet postVisit(SpreadSheet sheet, int rowIndex) {
        int count;
        DataRow row;
        SpreadSheet result = this.createOutputHeader();
        if (this.m_Numbers.size() > 0) {
            row = result.addRow();
            count = 0;
            for (Double d : this.m_Numbers.keySet()) {
                if (this.m_Numbers.get(d) != 1) continue;
                ++count;
            }
            row.addCell(0).setContent("Unique numbers");
            row.addCell(1).setContent(Integer.valueOf(count));
        }
        if (this.m_Labels.size() > 0) {
            row = result.addRow();
            count = 0;
            for (String s : this.m_Labels.keySet()) {
                if (this.m_Labels.get(s) != 1) continue;
                ++count;
            }
            row.addCell(0).setContent("Unique labels");
            row.addCell(1).setContent(Integer.valueOf(count));
        }
        this.m_Numbers = null;
        this.m_Labels = null;
        return result;
    }
}

