/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;

public class HasColumn
extends AbstractBooleanCondition {
    private static final long serialVersionUID = 2973832676958171541L;
    protected String m_Column;

    public String globalInfo() {
        return "Checks whether the spreadsheet passing through has a certain column.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column", "column", (Object)"");
    }

    public void setColumn(String value) {
        this.m_Column = value;
        this.reset();
    }

    public String getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column to look for in the spreadsheet.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)this.m_Column);
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected boolean doEvaluate(Actor owner, Token token) {
        SpreadSheet sheet = (SpreadSheet)token.getPayload();
        return sheet.getHeaderRow().indexOfContent(this.m_Column) > -1;
    }
}

