/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class NewSpreadSheet
extends AbstractSimpleSource {
    private static final long serialVersionUID = 494594301273926225L;
    protected String m_SheetName;
    protected String m_Columns;
    protected DataRow m_DataRowType;
    protected SpreadSheet m_SpreadSheetType;

    public String globalInfo() {
        return "Generates an empty spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("spreadsheet-name", "sheetName", (Object)"");
        this.m_OptionManager.add("columns", "columns", (Object)"A,B,C");
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)new DenseDataRow());
        this.m_OptionManager.add("spreadsheet-type", "spreadSheetType", (Object)new SpreadSheet());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"sheetName", (Object)this.m_Columns, (String)"name: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"columns", (Object)this.m_Columns, (String)", cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataRowType", (Object)this.m_DataRowType, (String)", row type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"spreadSheetType", this.m_SpreadSheetType.getClass(), (String)", sheet: ");
        return result;
    }

    public void setSheetName(String value) {
        this.m_SheetName = value;
        this.reset();
    }

    public String getSheetName() {
        return this.m_SheetName;
    }

    public String sheetNameTipText() {
        return "The name for the spreadsheet.";
    }

    public void setColumns(String value) {
        this.m_Columns = value;
        this.reset();
    }

    public String getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The comma-separated list of column names.";
    }

    public void setDataRowType(DataRow value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRow getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    public void setSpreadSheetType(SpreadSheet value) {
        this.m_SpreadSheetType = value;
        this.reset();
    }

    public SpreadSheet getSpreadSheetType() {
        return this.m_SpreadSheetType;
    }

    public String spreadSheetTypeTipText() {
        return "The type of spreadsheet to use for the data.";
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String[] cols;
        String result = null;
        SpreadSheet sheet = this.m_SpreadSheetType.newInstance();
        if (!this.m_SheetName.isEmpty()) {
            sheet.setName(this.m_SheetName);
        }
        sheet.setDataRowClass(this.m_DataRowType.getClass());
        for (String col : cols = this.m_Columns.split(",")) {
            sheet.getHeaderRow().addCell("" + sheet.getColumnCount()).setContentAsString(col);
        }
        this.m_OutputToken = new Token((Object)sheet);
        return result;
    }
}

