/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetRemoveColumn
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 6726489537611573393L;
    protected SpreadSheetColumnRange m_Position;

    public String globalInfo() {
        return "Removes the column(s) at the specific position from spreadsheets coming through.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Position = new SpreadSheetColumnRange();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("position", "position", (Object)new SpreadSheetColumnRange("first-last"));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"position", (Object)((Object)this.m_Position), (String)"range: ");
    }

    public void setPosition(SpreadSheetColumnRange value) {
        this.m_Position = value;
        this.reset();
    }

    public SpreadSheetColumnRange getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position of the columns to remove; " + this.m_Position.getExample();
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        sheet = sheet.getClone();
        this.m_Position.setSpreadSheet(sheet);
        int[] indices = this.m_Position.getIntIndices();
        if (indices.length > 0) {
            for (int i = indices.length - 1; i >= 0; --i) {
                sheet.removeColumn(indices[i]);
            }
            this.m_OutputToken = new Token((Object)sheet);
        } else {
            result = "Failed to locate column(s): " + this.m_Position.getRange();
        }
        return result;
    }
}

