/*
 * Decompiled with CFR 0.152.
 */
package adams.data.featureconverter;

import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.HeaderDefinition;
import java.util.ArrayList;
import java.util.List;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class Weka
extends AbstractFeatureConverter<Instances, Instance> {
    private static final long serialVersionUID = 2019318091828718405L;

    public String globalInfo() {
        return "Turns the features into Weka format.";
    }

    public Class getDatasetFormat() {
        return Instances.class;
    }

    public Class getRowFormat() {
        return Instance.class;
    }

    protected Instances doGenerateHeader(HeaderDefinition header) {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        block5: for (int i = 0; i < header.size(); ++i) {
            switch (header.getType(i)) {
                case BOOLEAN: {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add("yes");
                    values.add("no");
                    atts.add(new Attribute(header.getName(i), values));
                    continue block5;
                }
                case NUMERIC: {
                    atts.add(new Attribute(header.getName(i)));
                    continue block5;
                }
                case STRING: 
                case UNKNOWN: {
                    atts.add(new Attribute(header.getName(i), (List)null));
                }
            }
        }
        Instances result = new Instances(header.getDataset(), atts, 0);
        return result;
    }

    protected Instance doGenerateRow(List<Object> data) {
        double[] values = new double[((Instances)this.m_Header).numAttributes()];
        block5: for (int i = 0; i < data.size(); ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                values[i] = Utils.missingValue();
                continue;
            }
            switch (this.m_HeaderDefinition.getType(i)) {
                case BOOLEAN: {
                    values[i] = (Boolean)obj != false ? 0.0 : 1.0;
                    continue block5;
                }
                case NUMERIC: {
                    values[i] = ((Number)obj).doubleValue();
                    continue block5;
                }
                case STRING: 
                case UNKNOWN: {
                    values[i] = ((Instances)this.m_Header).attribute(i).addStringValue(obj.toString());
                }
            }
        }
        DenseInstance result = new DenseInstance(1.0, values);
        result.setDataset((Instances)this.m_Header);
        return result;
    }
}

